package org.jsmth.data.sql.sqlbuilder;

import org.jsmth.jorm.jdbc.Column;
import org.jsmth.jorm.jdbc.JPAHelper;
import org.jsmth.jorm.jdbc.Table;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/11/28.
 */
public class Update {
    StringBuilder updateItems = new StringBuilder();
    Where where = new Where();
    Class entityClass;
    String tableName = "";
    List sqlParas = new ArrayList<>();

    public Update(Class entityClass) {
        this.entityClass = entityClass;
        this.tableName = JPAHelper.getTableName(this.entityClass);
    }

    public Update field(String fieldItems,Object ... params) {
        if (fieldItems == null) {
            return this;
        }
        if(this.updateItems.length()>0){
            this.updateItems.append(",");
        }
        this.updateItems.append(fieldItems);
        if(sqlParas!=null && params.length>0) {
            for (Object sqlPara : params) {
                this.sqlParas.add(sqlPara);
            }
        }
        return this;
    }
    public Update where(Where where) {
        if (where == null) {
            return this;
        }
        this.where = this.where.combine(where);
        return this;
    }

    public String buildSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" UPDATE ");
        sql.append(getTableName());
        sql.append(" SET ");
        sql.append(updateItems.toString());
        String whereSql = where.buildSql();
        if (whereSql.length() > 0) {
            sql.append(" WHERE ");
            sql.append(whereSql);
        }
        return sql.toString();
    }
    public List getSqlParas() {
        List params=new ArrayList<>();
        params.addAll(this.sqlParas);
        params.addAll(this.where.getSqlParas());
        return params;
    }

    String getTableName() {
        return tableName;
    }

    //<editor-fold desc="f">
    public Update f(String selectItem) {
        return f(selectItem, new Object[0]);
    }

    public Update f(String fieldItem, Object... params) {
        return field(fieldItem,params);
    }
    public Update f(Object entity,boolean exclude,String...fieldNames) {
        Table table = new Table(entityClass);
        List<Column> columns = table.findColumns(exclude, fieldNames);
        StringBuilder sql = new StringBuilder();
        List params=new ArrayList<>();
        for (Column column : columns) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append(column.getColumnName());
            params.add(JPAHelper.getEntityFieldValue(entity,column.getFieldName()));
        }
        return field(sql.toString(),params.toArray());
    }
    //</editor-fold>
    //<editor-fold desc="delta">
    public Update fIncrease(String column) {
        return fDelta(column, 1);
    }
    public Update fDecrease(String column) {
        return fDelta(column, -1);
    }
    public Update fDelta(String column, int delta) {
        StringBuilder sql=new StringBuilder();
        sql.append(column);
        sql.append("=");
        sql.append(column);
        sql.append("+?");
        return f(sql.toString(), delta);
    }
    //</editor-fold>
    public Where getWhere() {
        return where;
    }
}
