package org.jsmth.data.sql.sqlbuilder;

import org.jsmth.jorm.jdbc.Column;
import org.jsmth.jorm.jdbc.JPAHelper;
import org.jsmth.jorm.jdbc.Table;

import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/11/28.
 */
public class Query {
    StringBuilder selects = new StringBuilder();
    StringBuilder orders = new StringBuilder();
    StringBuilder groups = new StringBuilder();
    Having having = new Having();
    Where where = new Where();
    Class entityClass;
    String tableName = "";

    public Query(Class entityClass) {
        this.entityClass = entityClass;
        this.tableName = JPAHelper.getTableName(this.entityClass);
    }

    public Query select(String... selectItems) {
        if (selectItems == null) {
            return this;
        }
        for (String key : selectItems) {
            if (selects.length() > 0) {
                selects.append(",");
            }
            selects.append(key);
        }
        return this;
    }

    public Query order(String... orderItems) {
        if (orderItems == null) {
            return this;
        }
        for (String key : orderItems) {
            if (orders.length() > 0) {
                orders.append(",");
            }
            orders.append(key);
        }
        return this;
    }

    public Query group(String... groupItems) {
        if (groupItems == null) {
            return this;
        }
        for (String key : groupItems) {
            if (groups.length() > 0) {
                groups.append(",");
            }
            groups.append(key);
        }
        return this;
    }

    public Query having(Having having) {
        if (having == null) {
            return this;
        }
        this.having = having;
        return this;
    }

    public Query where(Where where) {
        if (where == null) {
            return this;
        }
        this.where = this.where.combine(where);
        return this;
    }

    public String buildSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        if (selects.length() > 0) {
            sql.append(selects.toString());
        } else {
            sql.append(" COUNT(*) ");
        }
        sql.append(" FROM ");
        sql.append(getTableName());
        String whereSql = where.buildSql();
        if (whereSql.length() > 0) {
            sql.append(" WHERE ");
            sql.append(whereSql);
        }
        if (groups.length() > 0) {
            sql.append(" GROUP BY ");
            sql.append(groups.toString());
        }
        whereSql = having.buildSql();
        if (whereSql.length() > 0) {
            sql.append(" HAVING ");
            sql.append(whereSql);
        }
        if (orders.length() > 0) {
            sql.append(" ORDER BY ");
            sql.append(orders.toString());
        }
        return sql.toString();
    }
    public String buildLimitSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        if (selects.length() > 0) {
            sql.append(selects.toString());
        } else {
            sql.append(" COUNT(*) ");
        }
        sql.append(" FROM ");
        sql.append(getTableName());
        String whereSql = where.buildSql();
        if (whereSql.length() > 0) {
            sql.append(" WHERE ");
            sql.append(whereSql);
        }
        if (groups.length() > 0) {
            sql.append(" GROUP BY ");
            sql.append(groups.toString());
        }
        whereSql = having.buildSql();
        if (whereSql.length() > 0) {
            sql.append(" HAVING ");
            sql.append(whereSql);
        }
        if (orders.length() > 0) {
            sql.append(" ORDER BY ");
            sql.append(orders.toString());
        }
        return sql.toString();
    }
    public List getSqlParas() {
        return where.getSqlParas();
    }
    public List getLimitSqlParas() {
        return where.getSqlParas();
    }

    String getTableName() {
        return tableName;
    }

    public Query sAll() {
        return select("*");
    }


    //<editor-fold desc="s">
    public Query s(String selectItem) {
        return s(selectItem, null);
    }

    public Query s(String selectItem, String alias) {
        StringBuilder sql = new StringBuilder();
        sql.append(selectItem);
        if (org.apache.commons.lang.StringUtils.isNotBlank(alias)) {
            sql.append(" as ");
            sql.append(alias);
        }
        return select(sql.toString());
    }

    public Query s(String column, String method, String alias) {
        StringBuilder sql = new StringBuilder();
        sql.append(method + "(");
        if (org.apache.commons.lang.StringUtils.isNotBlank(column)) {
            sql.append(column);
        } else {
            sql.append("*");
        }
        sql.append(")");
        return s(sql.toString(), alias);
    }
    public Query s(boolean exclude, String... fieldNames) {
        Table table = new Table(entityClass);
        List<Column> columns = table.findColumns(exclude, fieldNames);
        StringBuilder sql = new StringBuilder();
        for (Column column : columns) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append(column.getColumnName());
        }
        return select(sql.toString());
    }

    //</editor-fold>
    //<editor-fold desc="select">
    public Query sCount() {
        return sCount( null);
    }
    public Query sCount(String column) {
        return sCount(column, null);
    }
    public Query sCount(String column, String alias) {
        return s("COUNT", column, alias);
    }

    public Query sMax(String column) {
        return sMax(column, null);
    }
    public Query sMax(String column, String alias) {
        return s("MAX", column, alias);
    }
    public Query sMin(String column) {
        return sMin(column, null);
    }
    public Query sMin(String column, String alias) {
        return s("MIN", column, alias);
    }
    public Query sAvg(String column) {
        return sAvg(column, null);
    }
    public Query sAvg(String column, String alias) {
        return s("AVG", column, alias);
    }
    public Query sFirst(String column) {
        return sFirst(column, null);
    }
    public Query sFirst(String column, String alias) {
        return s("FIRST", column, alias);
    }
    public Query sSum(String column) {
        return sSum(column, null);
    }
    public Query sSum(String column, String alias) {
        return s("Sum", column, alias);
    }
    public Query sDistinct(String column) {
        return sDistinct(column, null);
    }
    public Query sDistinct(String column, String alias) {
        StringBuilder sql = new StringBuilder();
        sql.append("DISTINCT ");
        sql.append(column);
        return s(sql.toString(), alias);
    }
    //</editor-fold>
    //<editor-fold desc="order">
    public Query order(boolean desc, String columnName){
        if(desc){
            return order(columnName +" desc");
        }else{
            return order(columnName );
        }
    }
    //</editor-fold>


    public int getPageNumber() {
        return where.getPageNumber();
    }

    public int getPageSize() {
        return where.getPageSize();
    }

    public boolean isTotalRecord() {
        return where.isTotalRecord();
    }

    public Where getWhere() {
        return where;
    }
}
