package org.jsmth.data.sql.sqlbuilder;

import org.jsmth.jorm.jdbc.JPAHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/11/28.
 */
public class Insert {
    StringBuilder updateItems = new StringBuilder();
    Where where = new Where();
    Class entityClass;
    String tableName = "";
    List sqlParas = new ArrayList<>();

    public Insert(Class entityClass) {
        this.entityClass = entityClass;
        this.tableName = JPAHelper.getTableName(this.entityClass);
    }

    public Insert field(String fieldItems, Object ... params) {
        if (fieldItems == null) {
            return this;
        }
        if(this.updateItems.length()>0){
            this.updateItems.append(",");
        }
        this.updateItems.append(fieldItems);
        if(sqlParas!=null && params.length>0) {
            for (Object sqlPara : params) {
                this.sqlParas.add(sqlPara);
            }
        }
        return this;
    }
    public Insert where(Where where) {
        if (where == null) {
            return this;
        }
        this.where = this.where.combine(where);
        return this;
    }

    public String buildSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" UPDATE ");
        sql.append(getTableName());
        sql.append(" SET ");
        sql.append(updateItems.toString());
        String whereSql = where.buildSql();
        if (whereSql.length() > 0) {
            sql.append(" WHERE ");
            sql.append(whereSql);
        }
        return sql.toString();
    }
    public List getSqlParas() {
        List params=new ArrayList<>();
        params.addAll(this.sqlParas);
        params.addAll(this.where.getSqlParas());
        return params;
    }

    String getTableName() {
        return tableName;
    }

    //<editor-fold desc="f">
    public Insert f(String selectItem) {
        return f(selectItem, null);
    }

    public Insert f(String fieldItem, Object... params) {
        return field(fieldItem,params);
    }
    //</editor-fold>
    //<editor-fold desc="delta">
    public Insert fIncrease(String column) {
        return fDelta(column, 1);
    }
    public Insert fDecrease(String column) {
        return fDelta(column, -1);
    }
    public Insert fDelta(String column, int delta) {
        StringBuilder sql=new StringBuilder();
        sql.append(column);
        sql.append("=");
        sql.append(column);
        sql.append("+?");
        return f(sql.toString(), delta);
    }
    //</editor-fold>
    public Where getWhere() {
        return where;
    }
}
