package org.jsmth.data.sql.item.where;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class LikeWhereItem extends OneColumnWhereItem {

    public static final String FIX_TAG = "%";

    boolean before;
    boolean after;



    public LikeWhereItem(String columnName, String keyword) {
        this(columnName, keyword, false, true);
    }

    public LikeWhereItem(String columnName, String keyword, boolean after) {
        this(columnName, keyword, false, after);
    }

    public LikeWhereItem( String columnName, String keyword, boolean before, boolean after) {
        this.fieldName = columnName;
        this.value = keyword;
        this.before = before;
        this.after = after;
    }

    @Override
    public String getSql() {
        if (!before && !after) {
            throw new IllegalArgumentException("befor and after value is both false.");
        }
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" like ");
        sql.append(dialect.getColumnValuePreTag(value.getClass()));
        if (before) {
            sql.append(FIX_TAG);
        }
        sql.append(value);
        if (after) {
            sql.append(FIX_TAG);
        }
        sql.append(dialect.getColumnValuePostTag(value.getClass()));
        sql.append(" ");
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        if (!before && !after) {
            throw new IllegalArgumentException("befor and after value is both false.");
        }
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" like '");
        if (before) {
            sql.append(FIX_TAG);
        }
        sql.append("?");
        sqlParas.add(value);
        if (after) {
            sql.append(FIX_TAG);
        }
        sql.append("' ");
        return sql.toString();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        if (!before && !after) {
            throw new IllegalArgumentException("befor and after value is both false.");
        }
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" like '");
        if (before) {
            sql.append(FIX_TAG);
        }
        sql.append(":");
        sql.append(fieldName);
        sqlParas.put(fieldName,value);
        if (after) {
            sql.append(FIX_TAG);
        }
        sql.append("' ");
        return sql.toString();
    }

    public List sqlParams() {
        List params = new LinkedList();
        params.add(value);
        return params;
    }


    public boolean isBefore() {
        return before;
    }

    public void setBefore(boolean before) {
        this.before = before;
    }

    public boolean isAfter() {
        return after;
    }

    public void setAfter(boolean after) {
        this.after = after;
    }
}
