package org.jsmth.data.sql.item.where;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class LessThanWhereItem extends OneColumnWhereItem {

    boolean equal;


    public LessThanWhereItem( String columnName, Object value) {
        this(columnName, value, false);
    }

    public LessThanWhereItem(String columnName, Object value, boolean equal) {
        this.fieldName = columnName;
        this.value = value;
        this.equal = equal;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        if (equal) {
            sql.append(" <= ");
        } else {
            sql.append(" < ");
        }
        sql.append(dialect.getColumnValuePreTag(value.getClass()));
        sql.append(value);
        sql.append(dialect.getColumnValuePostTag(value.getClass()));
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        if (equal) {
            sql.append(" <= ?");
        } else {
            sql.append(" < ?");
        }
        sqlParas.add(value);
        return sql.toString();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        if (equal) {
            sql.append(" <= :");
        } else {
            sql.append(" < :");
        }
        sql.append(fieldName);
        sqlParas.put(fieldName,value);
        return sql.toString();
    }

    public List sqlParams() {
        List params = new LinkedList();
        params.add(value);
        return params;
    }

    public boolean isEqual() {
        return equal;
    }

    public void setEqual(boolean equal) {
        this.equal = equal;
    }
}
