package org.jsmth.data.sql.item.where;

import org.apache.commons.lang.ArrayUtils;

import java.util.*;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class InWhereItem extends OneColumnWhereItem {

    boolean nullValueException=true;

    List values;
    public InWhereItem(String columnName, Object... values) {
        this( columnName,true, values);
    }
    public InWhereItem(String columnName, boolean nullValueException, Object... values) {
        this.values = new LinkedList();
        addWhere(columnName, values);
        this.nullValueException=nullValueException;
    }

    public void addWhere(String columnName, Object... values) {
        if (ArrayUtils.isEmpty(values)) {
            throw new IllegalArgumentException("values is empty,");
        }
        if (values.length == 1) {
            Collection items = new LinkedList();
            Object item = values[0];
            if (item instanceof Collection) {
                items.addAll((Collection) item);
            } else {
                items.add(item);
            }
            addWhere(columnName, items);
        } else
            addWhere(columnName, Arrays.asList(values));
    }

    public void addWhere(String columnName, Collection values) {
        this.fieldName = columnName;
        this.values.addAll(values);
    }

    public List getValues() {
        return values;
    }

    public void setValues(List values) {
        this.values = values;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        if(values==null ||values.size()==0){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" in (");
        StringBuilder in = new StringBuilder();
        for (Object value : values) {
            if (in.length() > 0) {
                in.append(",");
            }
            in.append(dialect.getColumnValuePreTag(value.getClass()));
            in.append(value);
            in.append(dialect.getColumnValuePostTag(value.getClass()));
        }
        sql.append(in.toString());
        sql.append(") ");
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        if(values==null ||values.size()==0){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" in (");
        StringBuilder in = new StringBuilder();
        for (Object value : values) {
            if (in.length() > 0) {
                in.append(",");
            }
            in.append("?");
            sqlParas.add(value);
        }
        sql.append(in.toString());
        sql.append(") ");
        return sql.toString();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        if(values==null ||values.size()==0){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" in (");
        sql.append(":");
        sql.append(fieldName);
        sql.append(") ");
        sqlParas.put(fieldName, values);
        return sql.toString();
    }

    public List sqlParams() {
        List params = new LinkedList();
        for (Object value : values) {
            params.add(value);
        }
        return params;
    }

    public boolean isNullValueException() {
        return nullValueException;
    }

    public void setNullValueException(boolean nullValueException) {
        this.nullValueException = nullValueException;
    }
}
