package org.jsmth.data.sql.item.where;




import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class EqualWhereItem extends OneColumnWhereItem {

    public EqualWhereItem(String columnName, Object value) {
        this.fieldName = columnName;
        this.value = value;
    }

    public <ENUM extends Enum> EqualWhereItem(String columnName, ENUM value, boolean ordinal) {
        this.fieldName = columnName;
        if (ordinal) {
            this.value = value.ordinal();
        } else {
            this.value = value.name();
        }
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" = ");
        sql.append(dialect.getColumnValuePreTag(value.getClass()));
        sql.append(value);
        sql.append(dialect.getColumnValuePostTag(value.getClass()));
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" = ?");
        sqlParas.add(value);
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        if(value==null){
            return sql.toString();
        }
        sql.append(fieldName);
        sql.append(" = :");
        sql.append(fieldName);
        sqlParas.put(fieldName, value);
        return sql.toString();
    }


    public List sqlParams() {
        List params = new LinkedList();
        params.add(value);
        return params;
    }

}
