package org.jsmth.data.sql.item.where;

import org.apache.commons.lang.StringUtils;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class BetweenThanWhereItem extends OneColumnWhereItem {

    Object beginValue;
    boolean beginEqual;
    Object endValue;
    boolean endEqual;


    public BetweenThanWhereItem(String columnName, Object beginValue, Object endValue) {
        this(columnName, beginValue, true, endValue, true);
    }

    public BetweenThanWhereItem(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        this.fieldName = columnName;
        this.beginValue = beginValue;
        this.beginEqual = beginEqual;
        this.endValue = endValue;
        this.endEqual = endEqual;
    }

    @Override
    public String getSql() {
        StringBuilder where = new StringBuilder();
        MoreThanWhereItem moreThanWhere = new MoreThanWhereItem(fieldName, beginValue, beginEqual);
        moreThanWhere.setDialect(this.dialect);
        LessThanWhereItem lessThanWhereItem = new LessThanWhereItem(fieldName, endValue, endEqual);
        lessThanWhereItem.setDialect(this.dialect);
        String moreThanWhereNameParamSql = moreThanWhere.getSql();
        String lessThanWhereItemNameParamSql = lessThanWhereItem.getSql();
        where.append(moreThanWhereNameParamSql);
        if (StringUtils.isNotBlank(moreThanWhereNameParamSql) && StringUtils.isNotBlank(lessThanWhereItemNameParamSql)) {
            where.append(" AND ");
        }
        where.append(lessThanWhereItemNameParamSql);
        return where.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder where = new StringBuilder();

        MoreThanWhereItem moreThanWhere = new MoreThanWhereItem(fieldName, beginValue, beginEqual);
        moreThanWhere.setDialect(this.dialect);
        LessThanWhereItem lessThanWhereItem = new LessThanWhereItem(fieldName, endValue, endEqual);
        lessThanWhereItem.setDialect(this.dialect);
        String moreThanWhereNameParamSql = moreThanWhere.getPlaceholderSql(sqlParas);
        String lessThanWhereItemNameParamSql = lessThanWhereItem.getPlaceholderSql(sqlParas);
        where.append(moreThanWhereNameParamSql);
        if (StringUtils.isNotBlank(moreThanWhereNameParamSql) && StringUtils.isNotBlank(lessThanWhereItemNameParamSql)) {
            where.append(" AND ");
        }
        where.append(lessThanWhereItemNameParamSql);
        return where.toString();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder where = new StringBuilder();

        MoreThanWhereItem moreThanWhere = new MoreThanWhereItem(fieldName, beginValue, beginEqual);
        moreThanWhere.setDialect(this.dialect);
        LessThanWhereItem lessThanWhereItem = new LessThanWhereItem(fieldName, endValue, endEqual);
        lessThanWhereItem.setDialect(this.dialect);
        String moreThanWhereNameParamSql = moreThanWhere.getNameParamSql(sqlParas);
        String lessThanWhereItemNameParamSql = lessThanWhereItem.getNameParamSql(sqlParas);
        where.append(moreThanWhereNameParamSql);
        if (StringUtils.isNotBlank(moreThanWhereNameParamSql) && StringUtils.isNotBlank(lessThanWhereItemNameParamSql)) {
            where.append(" AND ");
        }
        where.append(lessThanWhereItemNameParamSql);
        return where.toString();
    }

    public List sqlParams() {
        List params = new LinkedList();
        MoreThanWhereItem moreThanWhere = new MoreThanWhereItem(fieldName, beginValue, beginEqual);
        LessThanWhereItem lessThanWhereItem = new LessThanWhereItem(fieldName, endValue, endEqual);
        params.addAll(moreThanWhere.sqlParams());
        params.addAll(lessThanWhereItem.sqlParams());
        return params;
    }

    @Override
    public String toString() {
        return getSql();
    }


    public Object getBeginValue() {
        return beginValue;
    }

    public void setBeginValue(Object beginValue) {
        this.beginValue = beginValue;
    }

    public boolean isBeginEqual() {
        return beginEqual;
    }

    public void setBeginEqual(boolean beginEqual) {
        this.beginEqual = beginEqual;
    }

    public Object getEndValue() {
        return endValue;
    }

    public void setEndValue(Object endValue) {
        this.endValue = endValue;
    }

    public boolean isEndEqual() {
        return endEqual;
    }

    public void setEndEqual(boolean endEqual) {
        this.endEqual = endEqual;
    }
}
