package org.jsmth.data.sql.item;

import org.jsmth.data.sql.AbstractSqlItem;
import org.jsmth.data.sql.SqlItem;

import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class UpdateFieldItem extends AbstractSqlItem {
    String field;
    Object value;

    public UpdateFieldItem(String field, Object value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        if(value==null)
            throw new IllegalArgumentException("update field value is null");
        sql.append(field);
        sql.append("=");
        sql.append(dialect.getColumnValuePreTag(value.getClass()));
        sql.append(value);
        sql.append(dialect.getColumnValuePostTag(value.getClass()));
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        if(value==null)
            throw new IllegalArgumentException("update field value is null");
        sql.append(field);
        sql.append("= ?");
        sqlParas.add(value);
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        if(value==null)
            throw new IllegalArgumentException("update field value is null");
        sql.append(field);
        sql.append("= :");
        sql.append(field);
        sqlParas.put(field, value);
        return sql.toString();
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}
