package org.jsmth.data.sql.item;

import org.apache.commons.lang.StringUtils;
import org.jsmth.data.sql.AbstractSqlItem;
import org.jsmth.data.sql.SqlItem;

import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class SelectItem extends AbstractSqlItem {
    public final static String ALL_TAG = "*";
    protected String fieldName = "";
    protected String aliasName = "";
    SelectMethod selectMethod;

    public SelectItem(String columnName, String aliasName, SelectMethod selectMethod) {
        this.fieldName = columnName;
        this.aliasName = aliasName;
        this.selectMethod = selectMethod;
    }

    public SelectItem(String columnName, String aliasName) {
        this(columnName, aliasName, SelectMethod.DEFAULT);
    }

    public SelectItem(String columnName) {
        this(columnName, "");
    }


    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();
        if(selectMethod==SelectMethod.DEFAULT){
            sql.append(fieldName);
        } else if(selectMethod==SelectMethod.DISTINCT){
            sql.append("DISTINCT ");
            sql.append(fieldName);
        } else if(selectMethod==SelectMethod.FIRST){
            sql.append("FIRST ");
            sql.append(fieldName);
        } else if(selectMethod==SelectMethod.GROUP_AVG){
            sql.append("avg( ");
            sql.append(fieldName);
            sql.append(") ");
        } else if(selectMethod==SelectMethod.GROUP_COUNT){
            sql.append("count( ");
            sql.append(fieldName);
            sql.append(") ");
        } else if(selectMethod==SelectMethod.GROUP_SUM){
            sql.append("sum( ");
            sql.append(fieldName);
            sql.append(") ");
        } else if(selectMethod==SelectMethod.LAST){
            sql.append("LAST ");
            sql.append(fieldName);
        } else if(selectMethod==SelectMethod.LEN){
            sql.append("len( ");
            sql.append(fieldName);
            sql.append(") ");
        } else if(selectMethod==SelectMethod.MAX){
            sql.append("max( ");
            sql.append(fieldName);
            sql.append(") ");
        } else if(selectMethod==SelectMethod.MIN){
            sql.append("min( ");
            sql.append(fieldName);
            sql.append(") ");
        } else if(selectMethod==SelectMethod.TEAM){
            sql.append("trim( ");
            sql.append(fieldName);
            sql.append(") ");
        } else {

        }
        if(StringUtils.isNotBlank(aliasName)){
            sql.append(" as ");
            sql.append(aliasName);
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        return getSql();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        return getSql();
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getAliasName() {
        return aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public SelectMethod getSelectMethod() {
        return selectMethod;
    }

    public void setSelectMethod(SelectMethod selectMethod) {
        this.selectMethod = selectMethod;
    }
}
