package org.jsmth.data.sql.item;

import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/17.
 */
public class PatternUpdateItem extends UpdateFieldItem {

    String pattern;
    public PatternUpdateItem(String field,String pattern, Object value) {
        super(field, value);
        this.pattern=pattern;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();

        sql.append(field);
        sql.append("=");

        sql.append(dialect.getColumnValuePreTag(String.class));
        if(value!=null){
            if(value.toString().indexOf("?")>=0) {
                pattern = pattern.replace("?", value.toString());
            }
        }
        sql.append(pattern);
        sql.append(dialect.getColumnValuePostTag(String.class));
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append(field);
        sql.append("= ");
        if(value!=null){
            if(value.toString().indexOf("?")>=0) {
                sqlParas.add(value);
            }
        }
        sql.append(pattern);
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append(field);
        sql.append(" = ");
        if(value!=null){
            if(value.toString().indexOf("?")>=0) {
                pattern = pattern.replace("?", ":"+field);
                sqlParas.put(field, value);
            }
        }
        sql.append(dialect.getColumnValuePreTag(String.class));
        sql.append(pattern);
        sql.append(dialect.getColumnValuePostTag(String.class));
        return sql.toString();
    }


    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}
