package org.jsmth.data.sql.item;

import org.jsmth.data.sql.AbstractSqlItem;
import org.jsmth.data.sql.SqlItem;

import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/15.
 */
public class OrderItem extends AbstractSqlItem {
    String fieldName;
    OrderType style = OrderType.DEFAULT;


    public OrderItem(String columnName) {
        this(columnName, OrderType.DEFAULT);
    }

    public OrderItem(String columnName, OrderType style) {
        this.fieldName = columnName;
        this.style = style;
    }

    @Override
    public String getSql() {
        StringBuilder sql=new StringBuilder();

        sql.append(fieldName);
        if(style!=OrderType.DEFAULT){
            sql.append(" ");
            sql.append(style.name());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        return getSql();
    }
    @Override
    public String getNameParamSql(Map sqlParas) {
        return getSql();
    }
    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public OrderType getStyle() {
        return style;
    }

    public void setStyle(OrderType style) {
        this.style = style;
    }
}
