package org.jsmth.data.sql.item;

import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Index;
import org.jsmth.jorm.jdbc.schema.TableSchema;
import org.jsmth.data.sql.support.HibernateEntity;
import org.jsmth.data.sql.support.HibernateMapping;
import org.jsmth.data.sql.wrap.AbstractSqlItemWrap;

import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/21.
 */
public class DropIndexItem extends AbstractSqlItemWrap {
    Index hbIndex;
    TableSchema tableSchema;
    Dialect hibernateDialect;

    public DropIndexItem(Index hbIndex, TableSchema tableSchema, Dialect hibernateDialect) {
        this.hbIndex = hbIndex;
        this.tableSchema = tableSchema;
        this.hibernateDialect = hibernateDialect;
    }

    @Override
    public String getSql() {
        HibernateEntity hTableEntity = HibernateMapping.getHTable(tableSchema.getEntityClass(), hibernateDialect);
        return hbIndex.sqlDropString(hibernateDialect, hTableEntity.getDefaultCatalog(), hTableEntity.getDefaultSchema());
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        return getSql();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        return getSql();
    }
}
