package org.jsmth.data.sql;

import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.schema.EntityMapping;
import org.jsmth.jorm.jdbc.schema.TableSchema;
import org.jsmth.data.sql.item.*;
import org.jsmth.data.sql.wrap.*;

import java.util.List;
import java.util.Map;

/**
 * 数据查询语言（DQL:Data Query Language）：
 * 其语句，也称为“数据检索语句”，用以从表中获得数据，确定数据怎样在应用程序给出。保留字SELECT是DQL（也是所有SQL）用得最多的动词，其他DQL常用的保留字有WHERE，ORDER BY，GROUP BY和HAVING。这些DQL保留字常与其他类型的SQL语句一起使用。
 */
public class EntityUpdate extends AbstractWhereEntitySql {

    UpdateFieldWrap wrapUpdateField;
    TableSchema tableSchema;

    Class entityClass;
    public EntityUpdate(Class entityClass) {
        this(entityClass,new MySQLDialect());
    }

    public EntityUpdate(Class entityClass, Dialect dialect) {
        super(dialect);
        this.entityClass=entityClass;
        wrapUpdateField = new UpdateFieldWrap();
        tableSchema= EntityMapping.getTableSchema(entityClass);
    }

    public String getTableName(){
        return tableSchema.getTableName();
    }

    @Override
    public String getSql() {
        wrapUpdateField.setDialect(this.dialect);
        wrapWhere.setDialect(this.dialect);
        StringBuilder sql = new StringBuilder();
        sql.append("Update ");
        sql.append(getTableName());
        sql.append(" SET ");
        sql.append(wrapUpdateField.getSql());
        sql.append(getWhereBaseSql());

        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append("Update ");
        sql.append(getTableName());
        sql.append(" SET ");
        sql.append(wrapUpdateField.getPlaceholderSql(sqlParas));
        sql.append(getWherePlaceholderSql(sqlParas));
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append("Update ");
        sql.append(getTableName());
        sql.append(" SET ");
        sql.append(wrapUpdateField.getNameParamSql(sqlParas));
        sql.append(getWhereNameParamSql(sqlParas));
        return sql.toString();
    }


    public UpdateFieldWrap getWrapUpdateField() {
        return wrapUpdateField;
    }

    public void setWrapUpdateField(UpdateFieldWrap wrapUpdateField) {
        this.wrapUpdateField = wrapUpdateField;
    }


    //<editor-fold desc="where">
    public EntityUpdate w(WhereWrap wrap){
        return w(Logic.AND,wrap);
    }
    public EntityUpdate w(IWhereItem item){
        return w(Logic.AND,item);
    }
    public EntityUpdate w(Logic logic, WhereWrap wrap) {
        wrapWhere.w(logic, wrap);
        return this;
    }
    public EntityUpdate w(Logic logic, IWhereItem item) {
        wrapWhere.w(logic, item);
        return this;
    }

    public <ENUM extends Enum> EntityUpdate wEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wEqual(logic, columnName, value, ordinal);
        return this;
    }

    public EntityUpdate wNotEqual(Logic logic, String columnName, Object value) {
        wrapWhere.wNotEqual(logic, columnName, value);
        return this;
    }

    public EntityUpdate wLike(String columnName, String keyword, boolean after) {
        wrapWhere.wLike(columnName, keyword, after);
        return this;
    }

    public EntityUpdate wIn(String columnName, Object... values) {
        wrapWhere.wIn(columnName, values);
        return this;
    }



    public EntityUpdate wLessThan(String columnName, Object value) {
        wrapWhere.wLessThan(columnName, value);
        return this;
    }

    public EntityUpdate wIn(Logic logic, String columnName, Object... values) {
        wrapWhere.wIn(logic, columnName, values);
        return this;
    }

    public EntityUpdate wMoreThan(Logic logic, String columnName, Object value) {
        wrapWhere.wMoreThan(logic, columnName, value);
        return this;
    }

    public EntityUpdate wMoreThan(Logic logic, String columnName, Object value, boolean equal) {
        wrapWhere.wMoreThan(logic, columnName, value, equal);
        return this;
    }

    public EntityUpdate wBetweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        wrapWhere.wBetweenThan(columnName, beginValue, beginEqual, endValue, endEqual);
        return this;
    }

    public EntityUpdate wMoreThan(String columnName, Object value) {
        wrapWhere.wMoreThan(columnName, value);
        return this;
    }

    public <ENUM extends Enum> EntityUpdate wNotEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wNotEqual(logic, columnName, value, ordinal);
        return this;
    }

    public <ENUM extends Enum> EntityUpdate wNotEqual(String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wNotEqual(columnName, value, ordinal);
        return this;
    }

    public EntityUpdate wMoreThan(String columnName, Object value, boolean equal) {
        wrapWhere.wMoreThan(columnName, value, equal);
        return this;
    }

    public EntityUpdate wLike(Logic logic, String columnName, String keyword) {
        wrapWhere.wLike(logic, columnName, keyword);
        return this;
    }

    public EntityUpdate wLike(Logic logic, String columnName, String keyword, boolean before, boolean after) {
        wrapWhere.wLike(logic, columnName, keyword, before, after);
        return this;
    }

    public EntityUpdate wLessThan(Logic logic, String columnName, Object value, boolean equal) {
        wrapWhere.wLessThan(logic, columnName, value, equal);
        return this;
    }

    public EntityUpdate wLessThan(String columnName, Object value, boolean equal) {
        wrapWhere.wLessThan(columnName, value, equal);
        return this;
    }

    public EntityUpdate wEqual(String columnName, Object value) {
        wrapWhere.wEqual(columnName, value);
        return this;
    }

    public EntityUpdate wNotEqual(String columnName, Object value) {
        wrapWhere.wNotEqual(columnName, value);
        return this;
    }

    public EntityUpdate wEqual(Logic logic, String columnName, Object value) {
        wrapWhere.wEqual(logic, columnName, value);
        return this;
    }

    public EntityUpdate wIn(Logic logic, String columnName, boolean nullValueException, Object... values) {
        wrapWhere.wIn(logic, columnName, nullValueException, values);
        return this;
    }

    public EntityUpdate wId(Object value) {
        wrapWhere.wId(value);
        return this;
    }

    public EntityUpdate wLike(String columnName, String keyword, boolean before, boolean after) {
        wrapWhere.wLike(columnName, keyword, before, after);
        return this;
    }

    public EntityUpdate wBetweenThan(Logic logic, String columnName, Object beginValue, Object endValue) {
        wrapWhere.wBetweenThan(logic, columnName, beginValue, endValue);
        return this;
    }

    public EntityUpdate wBetweenThan(Logic logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        wrapWhere.wBetweenThan(logic, columnName, beginValue, beginEqual, endValue, endEqual);
        return this;
    }

    public EntityUpdate wLike(String columnName, String keyword) {
        wrapWhere.wLike(columnName, keyword);
        return this;
    }

    public EntityUpdate wLessThan(Logic logic, String columnName, Object value) {
        wrapWhere.wLessThan(logic, columnName, value);
        return this;
    }

    public EntityUpdate wLike(Logic logic, String columnName, String keyword, boolean after) {
        wrapWhere.wLike(logic, columnName, keyword, after);
        return this;
    }

    public <ENUM extends Enum> EntityUpdate wEqual(String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wEqual(columnName, value, ordinal);
        return this;
    }
    //</editor-fold>
}
