package org.jsmth.data.sql;

import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.schema.EntityMapping;
import org.jsmth.jorm.jdbc.schema.TableSchema;
import org.jsmth.data.sql.item.*;
import org.jsmth.data.sql.wrap.*;

import java.util.List;
import java.util.Map;

/**
 * 数据查询语言（DQL:Data Query Language）：
 * 其语句，也称为“数据检索语句”，用以从表中获得数据，确定数据怎样在应用程序给出。保留字SELECT是DQL（也是所有SQL）用得最多的动词，其他DQL常用的保留字有WHERE，ORDER BY，GROUP BY和HAVING。这些DQL保留字常与其他类型的SQL语句一起使用。
 */
public class EntityQuery extends AbstractWhereEntitySql {

    SelectWrap wrapSelect;
    OrderWrap wrapOrder;
    GroupWrap wrapGroup;
    HavingWrap wrapHaving;
    PageableItem pageableItem;
    TableSchema tableSchema;

    Class entityClass;

    public EntityQuery(Class entityClass) {
        this(entityClass, new MySQLDialect());
    }

    public EntityQuery(Class entityClass, Dialect dialect) {
        super(dialect);
        this.entityClass = entityClass;
        wrapSelect = new SelectWrap();
        wrapOrder = new OrderWrap();
        wrapGroup = new GroupWrap();
        wrapHaving = new HavingWrap();
        pageableItem = new PageableItem();
        tableSchema = EntityMapping.getTableSchema(entityClass);

    }

    public String getTableName() {
        return tableSchema.getTableName();
    }

    @Override

    public String getSql() {
        wrapSelect.setDialect(this.dialect);
        wrapWhere.setDialect(this.dialect);
        wrapOrder.setDialect(this.dialect);
        wrapGroup.setDialect(this.dialect);
        wrapHaving.setDialect(this.dialect);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        if (wrapSelect.isEmpt()) {
            sql.append("*");
        } else {

            sql.append(wrapSelect.getSql());
        }
        sql.append(" FROM ");
        sql.append(getTableName());
        sql.append(getWhereBaseSql());
        if (!wrapOrder.isEmpt()) {
            sql.append(" ORDER BY ");
            sql.append(wrapOrder.getSql());
        }
        if (!wrapGroup.isEmpt()) {
            sql.append(" GROUP BY ");
            sql.append(wrapGroup.getSql());
        }
        if (!wrapHaving.isEmpt()) {
            sql.append(" HAVING ");
            sql.append(wrapHaving.getSql());
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        if (wrapSelect.isEmpt()) {
            sql.append("*");
        } else {
            sql.append(wrapSelect.getPlaceholderSql(sqlParas));
        }
        sql.append(" FROM ");
        sql.append(getTableName());
        sql.append(getWherePlaceholderSql(sqlParas));
        if (!wrapOrder.isEmpt()) {
            sql.append(" ORDER BY ");
            sql.append(wrapOrder.getPlaceholderSql(sqlParas));
        }
        if (!wrapGroup.isEmpt()) {
            sql.append(" GROUP BY ");
            sql.append(wrapGroup.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        if (wrapSelect.isEmpt()) {
            sql.append("*");
        } else {
            sql.append(wrapSelect.getNameParamSql(sqlParas));
        }
        sql.append(" FROM ");
        sql.append(getTableName());
        sql.append(getWhereNameParamSql(sqlParas));
        if (!wrapOrder.isEmpt()) {
            sql.append(" ORDER BY ");
            sql.append(wrapOrder.getNameParamSql(sqlParas));
        }
        if (!wrapGroup.isEmpt()) {
            sql.append(" GROUP BY ");
            sql.append(wrapGroup.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }


    public String getPageSql() {
        wrapSelect.setDialect(this.dialect);
        wrapWhere.setDialect(this.dialect);
        wrapOrder.setDialect(this.dialect);
        wrapGroup.setDialect(this.dialect);
        wrapHaving.setDialect(this.dialect);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("count(*) as count");
        sql.append(" FROM ");
        sql.append(getTableName());
        sql.append(getWhereBaseSql());
        if (!wrapGroup.isEmpt()) {
            sql.append(" GROUP BY ");
            sql.append(wrapGroup.getSql());
        }
        if (!wrapHaving.isEmpt()) {
            sql.append(" HAVING ");
            sql.append(wrapHaving.getSql());
        }
        return sql.toString();
    }

    public String getPagePlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("count(*) as count");
        sql.append(" FROM ");
        sql.append(getTableName());
        sql.append(getWherePlaceholderSql(sqlParas));
        if (!wrapGroup.isEmpt()) {
            sql.append(" GROUP BY ");
            sql.append(wrapGroup.getPlaceholderSql(sqlParas));
        }
        return sql.toString();
    }

    public String getPageNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("count(*) as count");
        sql.append(" FROM ");
        sql.append(getTableName());
        sql.append(getWhereNameParamSql(sqlParas));
        if (!wrapGroup.isEmpt()) {
            sql.append(" GROUP BY ");
            sql.append(wrapGroup.getNameParamSql(sqlParas));
        }
        return sql.toString();
    }

    public SelectWrap getWrapSelect() {
        return wrapSelect;
    }

    public void setWrapSelect(SelectWrap wrapSelect) {
        this.wrapSelect = wrapSelect;
    }


    public OrderWrap getWrapOrder() {
        return wrapOrder;
    }

    public void setWrapOrder(OrderWrap wrapOrder) {
        this.wrapOrder = wrapOrder;
    }

    public GroupWrap getWrapGroup() {
        return wrapGroup;
    }

    public void setWrapGroup(GroupWrap wrapGroup) {
        this.wrapGroup = wrapGroup;
    }

    public HavingWrap getWrapHaving() {
        return wrapHaving;
    }

    public void setWrapHaving(HavingWrap wrapHaving) {
        this.wrapHaving = wrapHaving;
    }

    public PageableItem getPageableItem() {
        return pageableItem;
    }

    public void setPageableItem(PageableItem pageableItem) {
        this.pageableItem = pageableItem;
    }

    //<editor-fold desc="page">
    public EntityQuery page(PageableItem item) {
        pageableItem = item;
        return this;
    }

    public EntityQuery page(int pageNumber, int pageSize) {
        pageableItem = new PageableItem(pageNumber, pageSize);
        return this;
    }

    public EntityQuery page(int pageNumber, int pageSize, boolean totalRecord) {
        pageableItem = new PageableItem(pageNumber, pageSize, totalRecord);
        return this;
    }

    //</editor-fold>
    //<editor-fold desc="select">
    public EntityQuery s(SelectWrap wrap) {
        wrapSelect.select(wrap);
        return this;
    }

    public EntityQuery s(String columnName) {
        wrapSelect.select(columnName);
        return this;
    }

    public EntityQuery s(String columnName, String aliasName, SelectMethod selectMethod) {
        wrapSelect.select(columnName, aliasName, selectMethod);
        return this;
    }

    public EntityQuery s(String columnName, String aliasName) {
        wrapSelect.select(columnName, aliasName);
        return this;
    }

    public EntityQuery s(SelectItem item) {
        wrapSelect.select(item);
        return this;
    }

    //</editor-fold>
    //<editor-fold desc="where">
    public EntityQuery w(WhereWrap wrap) {
        return w(Logic.AND, wrap);
    }

    public EntityQuery w(IWhereItem item) {
        return w(Logic.AND, item);
    }

    public EntityQuery w(Logic logic, WhereWrap wrap) {
        wrapWhere.w(logic, wrap);
        return this;
    }

    public EntityQuery w(Logic logic, IWhereItem item) {
        wrapWhere.w(logic, item);
        return this;
    }

    public <ENUM extends Enum> EntityQuery wEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wEqual(logic, columnName, value, ordinal);
        return this;
    }

    public EntityQuery wNotEqual(Logic logic, String columnName, Object value) {
        wrapWhere.wNotEqual(logic, columnName, value);
        return this;
    }

    public EntityQuery wLike(String columnName, String keyword, boolean after) {
        wrapWhere.wLike(columnName, keyword, after);
        return this;
    }

    public EntityQuery wIn(String columnName, Object... values) {
        wrapWhere.wIn(columnName, values);
        return this;
    }


    public EntityQuery wLessThan(String columnName, Object value) {
        wrapWhere.wLessThan(columnName, value);
        return this;
    }

    public EntityQuery wIn(Logic logic, String columnName, Object... values) {
        wrapWhere.wIn(logic, columnName, values);
        return this;
    }

    public EntityQuery wMoreThan(Logic logic, String columnName, Object value) {
        wrapWhere.wMoreThan(logic, columnName, value);
        return this;
    }

    public EntityQuery wMoreThan(Logic logic, String columnName, Object value, boolean equal) {
        wrapWhere.wMoreThan(logic, columnName, value, equal);
        return this;
    }

    public EntityQuery wBetweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        wrapWhere.wBetweenThan(columnName, beginValue, beginEqual, endValue, endEqual);
        return this;
    }

    public EntityQuery wMoreThan(String columnName, Object value) {
        wrapWhere.wMoreThan(columnName, value);
        return this;
    }

    public <ENUM extends Enum> EntityQuery wNotEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wNotEqual(logic, columnName, value, ordinal);
        return this;
    }

    public <ENUM extends Enum> EntityQuery wNotEqual(String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wNotEqual(columnName, value, ordinal);
        return this;
    }

    public EntityQuery wMoreThan(String columnName, Object value, boolean equal) {
        wrapWhere.wMoreThan(columnName, value, equal);
        return this;
    }

    public EntityQuery wLike(Logic logic, String columnName, String keyword) {
        wrapWhere.wLike(logic, columnName, keyword);
        return this;
    }

    public EntityQuery wLike(Logic logic, String columnName, String keyword, boolean before, boolean after) {
        wrapWhere.wLike(logic, columnName, keyword, before, after);
        return this;
    }

    public EntityQuery wLessThan(Logic logic, String columnName, Object value, boolean equal) {
        wrapWhere.wLessThan(logic, columnName, value, equal);
        return this;
    }

    public EntityQuery wLessThan(String columnName, Object value, boolean equal) {
        wrapWhere.wLessThan(columnName, value, equal);
        return this;
    }

    public EntityQuery wEqual(String columnName, Object value) {
        wrapWhere.wEqual(columnName, value);
        return this;
    }

    public EntityQuery wNotEqual(String columnName, Object value) {
        wrapWhere.wNotEqual(columnName, value);
        return this;
    }

    public EntityQuery wEqual(Logic logic, String columnName, Object value) {
        wrapWhere.wEqual(logic, columnName, value);
        return this;
    }

    public EntityQuery wIn(Logic logic, String columnName, boolean nullValueException, Object... values) {
        wrapWhere.wIn(logic, columnName, nullValueException, values);
        return this;
    }

    public EntityQuery wId(Object value) {
        wrapWhere.wId(value);
        return this;
    }

    public EntityQuery wLike(String columnName, String keyword, boolean before, boolean after) {
        wrapWhere.wLike(columnName, keyword, before, after);
        return this;
    }

    public EntityQuery wBetweenThan(Logic logic, String columnName, Object beginValue, Object endValue) {
        wrapWhere.wBetweenThan(logic, columnName, beginValue, endValue);
        return this;
    }

    public EntityQuery wBetweenThan(Logic logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        wrapWhere.wBetweenThan(logic, columnName, beginValue, beginEqual, endValue, endEqual);
        return this;
    }

    public EntityQuery wLike(String columnName, String keyword) {
        wrapWhere.wLike(columnName, keyword);
        return this;
    }

    public EntityQuery wLessThan(Logic logic, String columnName, Object value) {
        wrapWhere.wLessThan(logic, columnName, value);
        return this;
    }

    public EntityQuery wLike(Logic logic, String columnName, String keyword, boolean after) {
        wrapWhere.wLike(logic, columnName, keyword, after);
        return this;
    }

    public <ENUM extends Enum> EntityQuery wEqual(String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wEqual(columnName, value, ordinal);
        return this;
    }
    //</editor-fold>
    //<editor-fold desc="order">

    public EntityQuery o(OrderWrap wrap) {
        wrapOrder.order(wrap);
        return this;
    }

    public EntityQuery o(OrderItem item) {
        wrapOrder.order(item);
        return this;
    }

    public EntityQuery o(String fieldName) {
        wrapOrder.order(fieldName);
        return this;
    }

    public EntityQuery o(String fieldName, OrderType style) {
        wrapOrder.order(fieldName, style);
        return this;
    }

    //</editor-fold>
    // <editor-fold desc="having">
    public EntityQuery h(WhereWrap wrap) {
        return h(Logic.AND, wrap);
    }

    public EntityQuery h(IWhereItem item) {
        return h(Logic.AND, item);
    }

    public EntityQuery h(Logic logic, WhereWrap wrap) {
        wrapHaving.h(logic, wrap);
        return this;
    }

    public EntityQuery h(Logic logic, IWhereItem item) {
        wrapHaving.h(logic, item);
        return this;
    }

    public <ENUM extends Enum> EntityQuery hEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        wrapHaving.hEqual(logic, columnName, value, ordinal);
        return this;
    }

    public EntityQuery hNotEqual(Logic logic, String columnName, Object value) {
        wrapHaving.hNotEqual(logic, columnName, value);
        return this;
    }

    public EntityQuery hLike(String columnName, String keyword, boolean after) {
        wrapHaving.hLike(columnName, keyword, after);
        return this;
    }

    public EntityQuery hIn(String columnName, Object... values) {
        wrapHaving.hIn(columnName, values);
        return this;
    }


    public EntityQuery hLessThan(String columnName, Object value) {
        wrapHaving.hLessThan(columnName, value);
        return this;
    }

    public EntityQuery hIn(Logic logic, String columnName, Object... values) {
        wrapHaving.hIn(logic, columnName, values);
        return this;
    }

    public EntityQuery hMoreThan(Logic logic, String columnName, Object value) {
        wrapHaving.hMoreThan(logic, columnName, value);
        return this;
    }

    public EntityQuery hMoreThan(Logic logic, String columnName, Object value, boolean equal) {
        wrapHaving.hMoreThan(logic, columnName, value, equal);
        return this;
    }

    public EntityQuery hBetweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        wrapHaving.hBetweenThan(columnName, beginValue, beginEqual, endValue, endEqual);
        return this;
    }

    public EntityQuery hMoreThan(String columnName, Object value) {
        wrapHaving.hMoreThan(columnName, value);
        return this;
    }

    public <ENUM extends Enum> EntityQuery hNotEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        wrapHaving.hNotEqual(logic, columnName, value, ordinal);
        return this;
    }

    public <ENUM extends Enum> EntityQuery hNotEqual(String columnName, ENUM value, boolean ordinal) {
        wrapHaving.hNotEqual(columnName, value, ordinal);
        return this;
    }

    public EntityQuery hMoreThan(String columnName, Object value, boolean equal) {
        wrapHaving.hMoreThan(columnName, value, equal);
        return this;
    }

    public EntityQuery hLike(Logic logic, String columnName, String keyword) {
        wrapHaving.hLike(logic, columnName, keyword);
        return this;
    }

    public EntityQuery hLike(Logic logic, String columnName, String keyword, boolean before, boolean after) {
        wrapHaving.hLike(logic, columnName, keyword, before, after);
        return this;
    }

    public EntityQuery hLessThan(Logic logic, String columnName, Object value, boolean equal) {
        wrapHaving.hLessThan(logic, columnName, value, equal);
        return this;
    }

    public EntityQuery hLessThan(String columnName, Object value, boolean equal) {
        wrapHaving.hLessThan(columnName, value, equal);
        return this;
    }

    public EntityQuery hEqual(String columnName, Object value) {
        wrapHaving.hEqual(columnName, value);
        return this;
    }

    public EntityQuery hNotEqual(String columnName, Object value) {
        wrapHaving.hNotEqual(columnName, value);
        return this;
    }

    public EntityQuery hEqual(Logic logic, String columnName, Object value) {
        wrapHaving.hEqual(logic, columnName, value);
        return this;
    }

    public EntityQuery hIn(Logic logic, String columnName, boolean nullValueException, Object... values) {
        wrapHaving.hIn(logic, columnName, nullValueException, values);
        return this;
    }

    public EntityQuery hId(Object value) {
        wrapHaving.hId(value);
        return this;
    }

    public EntityQuery hLike(String columnName, String keyword, boolean before, boolean after) {
        wrapHaving.hLike(columnName, keyword, before, after);
        return this;
    }

    public EntityQuery hBetweenThan(Logic logic, String columnName, Object beginValue, Object endValue) {
        wrapHaving.hBetweenThan(logic, columnName, beginValue, endValue);
        return this;
    }

    public EntityQuery hBetweenThan(Logic logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        wrapHaving.hBetweenThan(logic, columnName, beginValue, beginEqual, endValue, endEqual);
        return this;
    }

    public EntityQuery hLike(String columnName, String keyword) {
        wrapHaving.hLike(columnName, keyword);
        return this;
    }

    public EntityQuery hLessThan(Logic logic, String columnName, Object value) {
        wrapHaving.hLessThan(logic, columnName, value);
        return this;
    }

    public EntityQuery hLike(Logic logic, String columnName, String keyword, boolean after) {
        wrapHaving.hLike(logic, columnName, keyword, after);
        return this;
    }

    public <ENUM extends Enum> EntityQuery hEqual(String columnName, ENUM value, boolean ordinal) {
        wrapHaving.hEqual(columnName, value, ordinal);
        return this;
    }

    //</editor-fold>
    //<editor-fold desc="group">
    public EntityQuery g(GroupWrap wrap) {
        wrapGroup.Group(wrap);
        return this;
    }

    public EntityQuery g(GroupItem item) {
        wrapGroup.group(item);
        return this;
    }

    public EntityQuery g(String fieldName) {
        wrapGroup.group(fieldName);
        return this;
    }
    //</editor-fold>
}
