package org.jsmth.data.sql;

import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.schema.EntityMapping;
import org.jsmth.jorm.jdbc.schema.TableSchema;
import org.jsmth.data.sql.wrap.InsertFieldWrap;
import org.jsmth.data.sql.wrap.InsertValueWrap;
import org.jsmth.data.sql.wrap.WhereWrap;

import java.util.List;
import java.util.Map;

/**
 * 数据查询语言（DQL:Data Query Language）：
 * 其语句，也称为“数据检索语句”，用以从表中获得数据，确定数据怎样在应用程序给出。保留字SELECT是DQL（也是所有SQL）用得最多的动词，其他DQL常用的保留字有WHERE，ORDER BY，GROUP BY和HAVING。这些DQL保留字常与其他类型的SQL语句一起使用。
 */
public class EntityInsert extends AbstractEntitySql {

    InsertFieldWrap wrapInsertField;
    InsertValueWrap wrapInsertValue;
    TableSchema tableSchema;
    boolean addGetKeySql=false;

    Class entityClass;
    public EntityInsert(Class entityClass) {
        this(entityClass,new MySQLDialect());
    }

    public EntityInsert(Class entityClass, Dialect dialect) {
        super(dialect);
        this.entityClass=entityClass;
        wrapInsertField = new InsertFieldWrap();
        wrapInsertValue = new InsertValueWrap();
        tableSchema= EntityMapping.getTableSchema(entityClass);
    }

    public String getTableName(){
        return tableSchema.getTableName();
    }

    @Override
    public String getSql() {
        wrapInsertField.setDialect(this.dialect);
        wrapInsertValue.setDialect(this.dialect);
        StringBuilder sql = new StringBuilder();
        sql.append("Insert into ");
        sql.append(getTableName());
        sql.append(" (");
        sql.append(wrapInsertField.getSql());
        sql.append(" )");
        sql.append(" VALUES (");
        sql.append(wrapInsertValue.getSql());
        sql.append(" )");
        if(addGetKeySql){
            sql.append(dialect.addInsertAfterGetKeyString(""));
        }
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        wrapInsertField.setDialect(this.dialect);
        wrapInsertValue.setDialect(this.dialect);
        StringBuilder sql = new StringBuilder();
        sql.append("Insert into ");
        sql.append(getTableName());
        sql.append(" (");
        sql.append(wrapInsertField.getPlaceholderSql(sqlParas));
        sql.append(" )");
        sql.append(" VALUES (");
        sql.append(wrapInsertValue.getPlaceholderSql(sqlParas));
        sql.append(" )");
        if(addGetKeySql){
            sql.append(dialect.addInsertAfterGetKeyString(""));
        }
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        wrapInsertField.setDialect(this.dialect);
        wrapInsertValue.setDialect(this.dialect);
        StringBuilder sql = new StringBuilder();
        sql.append("Insert into ");
        sql.append(getTableName());
        sql.append(" (");
        sql.append(wrapInsertField.getNameParamSql(sqlParas));
        sql.append(" )");
        sql.append(" VALUES (");
        sql.append(wrapInsertValue.getNameParamSql(sqlParas));
        sql.append(" )");
        if(addGetKeySql){
            sql.append(dialect.addInsertAfterGetKeyString(""));
        }
        return sql.toString();
    }

    public InsertFieldWrap getWrapInsertField() {
        return wrapInsertField;
    }

    public void setWrapInsertField(InsertFieldWrap wrapInsertField) {
        this.wrapInsertField = wrapInsertField;
    }

    public InsertValueWrap getWrapInsertValue() {
        return wrapInsertValue;
    }

    public void setWrapInsertValue(InsertValueWrap wrapInsertValue) {
        this.wrapInsertValue = wrapInsertValue;
    }

    public boolean isAddGetKeySql() {
        return addGetKeySql;
    }

    public void setAddGetKeySql(boolean addGetKeySql) {
        this.addGetKeySql = addGetKeySql;
    }

    //<editor-fold desc="Update">


    //</editor-fold>

}
