package org.jsmth.data.sql;

import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.schema.EntityMapping;
import org.jsmth.data.sql.wrap.*;
import org.jsmth.jorm.jdbc.schema.TableSchema;
import org.jsmth.data.sql.item.IWhereItem;
import org.jsmth.data.sql.item.Logic;

import java.util.List;
import java.util.Map;

/**
 * 数据查询语言（DQL:Data Query Language）：
 * 其语句，也称为“数据检索语句”，用以从表中获得数据，确定数据怎样在应用程序给出。保留字SELECT是DQL（也是所有SQL）用得最多的动词，其他DQL常用的保留字有WHERE，ORDER BY，GROUP BY和HAVING。这些DQL保留字常与其他类型的SQL语句一起使用。
 */
public class EntityDelete extends AbstractWhereEntitySql {

    TableSchema tableSchema;

    Class entityClass;
    public EntityDelete(Class entityClass) {
        this(entityClass,new MySQLDialect());
    }

    public EntityDelete(Class entityClass, Dialect dialect) {
        super(dialect);
        this.entityClass=entityClass;
        tableSchema= EntityMapping.getTableSchema(entityClass);
    }

    public String getTableName(){
        return tableSchema.getTableName();
    }

    @Override
    public String getSql() {
        wrapWhere.setDialect(this.dialect);
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(getTableName());
        sql.append(getWhereBaseSql());
        return sql.toString();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(getTableName());
        sql.append(getWherePlaceholderSql(sqlParas));
        return sql.toString();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(getTableName());
        sql.append(getWhereNameParamSql(sqlParas));
        return sql.toString();
    }

    public WhereWrap getWrapWhere() {
        return wrapWhere;
    }

    public void setWrapWhere(WhereWrap wrapWhere) {
        this.wrapWhere = wrapWhere;
    }


  //<editor-fold desc="where">
    public EntityDelete w(WhereWrap wrap){
        return w(Logic.AND,wrap);
    }
    public EntityDelete w(IWhereItem item){
        return w(Logic.AND,item);
    }
    public EntityDelete w(Logic logic, WhereWrap wrap) {
        wrapWhere.w(logic, wrap);
        return this;
    }
    public EntityDelete w(Logic logic, IWhereItem item) {
        wrapWhere.w(logic, item);
        return this;
    }

    public <ENUM extends Enum> EntityDelete wEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wEqual(logic, columnName, value, ordinal);
        return this;
    }

    public EntityDelete wNotEqual(Logic logic, String columnName, Object value) {
        wrapWhere.wNotEqual(logic, columnName, value);
        return this;
    }

    public EntityDelete wLike(String columnName, String keyword, boolean after) {
        wrapWhere.wLike(columnName, keyword, after);
        return this;
    }

    public EntityDelete wIn(String columnName, Object... values) {
        wrapWhere.wIn(columnName, values);
        return this;
    }



    public EntityDelete wLessThan(String columnName, Object value) {
        wrapWhere.wLessThan(columnName, value);
        return this;
    }

    public EntityDelete wIn(Logic logic, String columnName, Object... values) {
        wrapWhere.wIn(logic, columnName, values);
        return this;
    }

    public EntityDelete wMoreThan(Logic logic, String columnName, Object value) {
        wrapWhere.wMoreThan(logic, columnName, value);
        return this;
    }

    public EntityDelete wMoreThan(Logic logic, String columnName, Object value, boolean equal) {
        wrapWhere.wMoreThan(logic, columnName, value, equal);
        return this;
    }

    public EntityDelete wBetweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        wrapWhere.wBetweenThan(columnName, beginValue, beginEqual, endValue, endEqual);
        return this;
    }

    public EntityDelete wMoreThan(String columnName, Object value) {
        wrapWhere.wMoreThan(columnName, value);
        return this;
    }

    public <ENUM extends Enum> EntityDelete wNotEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wNotEqual(logic, columnName, value, ordinal);
        return this;
    }

    public <ENUM extends Enum> EntityDelete wNotEqual(String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wNotEqual(columnName, value, ordinal);
        return this;
    }

    public EntityDelete wMoreThan(String columnName, Object value, boolean equal) {
        wrapWhere.wMoreThan(columnName, value, equal);
        return this;
    }

    public EntityDelete wLike(Logic logic, String columnName, String keyword) {
        wrapWhere.wLike(logic, columnName, keyword);
        return this;
    }

    public EntityDelete wLike(Logic logic, String columnName, String keyword, boolean before, boolean after) {
        wrapWhere.wLike(logic, columnName, keyword, before, after);
        return this;
    }

    public EntityDelete wLessThan(Logic logic, String columnName, Object value, boolean equal) {
        wrapWhere.wLessThan(logic, columnName, value, equal);
        return this;
    }

    public EntityDelete wLessThan(String columnName, Object value, boolean equal) {
        wrapWhere.wLessThan(columnName, value, equal);
        return this;
    }

    public EntityDelete wEqual(String columnName, Object value) {
        wrapWhere.wEqual(columnName, value);
        return this;
    }

    public EntityDelete wNotEqual(String columnName, Object value) {
        wrapWhere.wNotEqual(columnName, value);
        return this;
    }

    public EntityDelete wEqual(Logic logic, String columnName, Object value) {
        wrapWhere.wEqual(logic, columnName, value);
        return this;
    }

    public EntityDelete wIn(Logic logic, String columnName, boolean nullValueException, Object... values) {
        wrapWhere.wIn(logic, columnName, nullValueException, values);
        return this;
    }

    public EntityDelete wId(Object value) {
        wrapWhere.wId(value);
        return this;
    }

    public EntityDelete wLike(String columnName, String keyword, boolean before, boolean after) {
        wrapWhere.wLike(columnName, keyword, before, after);
        return this;
    }

    public EntityDelete wBetweenThan(Logic logic, String columnName, Object beginValue, Object endValue) {
        wrapWhere.wBetweenThan(logic, columnName, beginValue, endValue);
        return this;
    }

    public EntityDelete wBetweenThan(Logic logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        wrapWhere.wBetweenThan(logic, columnName, beginValue, beginEqual, endValue, endEqual);
        return this;
    }

    public EntityDelete wLike(String columnName, String keyword) {
        wrapWhere.wLike(columnName, keyword);
        return this;
    }

    public EntityDelete wLessThan(Logic logic, String columnName, Object value) {
        wrapWhere.wLessThan(logic, columnName, value);
        return this;
    }

    public EntityDelete wLike(Logic logic, String columnName, String keyword, boolean after) {
        wrapWhere.wLike(logic, columnName, keyword, after);
        return this;
    }

    public <ENUM extends Enum> EntityDelete wEqual(String columnName, ENUM value, boolean ordinal) {
        wrapWhere.wEqual(columnName, value, ordinal);
        return this;
    }
    //</editor-fold>
}
