package org.jsmth.data.sql;

import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.DialectFactory;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.schema.EntityMapping;
import org.jsmth.data.sql.wrap.DropIndexWrap;
import org.jsmth.jorm.jdbc.schema.TableSchema;

import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/20.
 */
public class DropIndexSchemaClause extends AbstractEntitySql {
    Class entityClass;
    TableSchema tableSchema;
    DropIndexWrap dropIndexWrap;


    public DropIndexSchemaClause(Class entityClass) {
        this(new MySQLDialect(),entityClass);
    }

    public DropIndexSchemaClause(Dialect dialect, Class entityClass) {
        super(dialect);
        this.entityClass = entityClass;
        tableSchema= EntityMapping.getTableSchema(entityClass);
    }

    @Override
    public String getSql() {
        org.hibernate.dialect.Dialect hibernateDialect = DialectFactory.getHibernateDialect(dialect);
        dropIndexWrap=new DropIndexWrap(tableSchema,hibernateDialect);
        return dropIndexWrap.getSql();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        return getSql();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        return getSql();
    }

    public DropIndexWrap getDropIndexWrap() {
        return dropIndexWrap;
    }

    public void setDropIndexWrap(DropIndexWrap dropIndexWrap) {
        this.dropIndexWrap = dropIndexWrap;
    }
}
