package org.jsmth.data.sql;

import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.DialectFactory;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.schema.EntityMapping;
import org.jsmth.jorm.jdbc.schema.TableSchema;
import org.jsmth.data.sql.support.HibernateEntity;
import org.jsmth.data.sql.support.HibernateMapping;

import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/20.
 */
public class CreateTableSchemaClause  extends AbstractEntitySql {
    Class entityClass;
    TableSchema tableSchema;

    public CreateTableSchemaClause(Class entityClass) {
        this(new MySQLDialect(),entityClass);
    }

    public CreateTableSchemaClause(Dialect dialect, Class entityClass) {
        super(dialect);
        this.entityClass = entityClass;
        tableSchema= EntityMapping.getTableSchema(entityClass);
    }

    @Override
    public String getSql() {
        org.hibernate.dialect.Dialect hibernateDialect = DialectFactory.getHibernateDialect(dialect);
        HibernateEntity hTableEntity = HibernateMapping.getHTable(entityClass, hibernateDialect);


        String sql = hTableEntity.getTable().sqlCreateString(hibernateDialect, hTableEntity.getMapping(), hTableEntity.getDefaultCatalog(), hTableEntity.getDefaultSchema());
        return sql;
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        return getSql();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        return getSql();
    }
}
