package org.jsmth.data.sql;

import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.DialectFactory;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.schema.EntityMapping;
import org.jsmth.data.sql.wrap.CreateIndexWrap;
import org.jsmth.jorm.jdbc.schema.TableSchema;

import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/20.
 */
public class CreateIndexSchemaClause extends AbstractEntitySql {
    Class entityClass;
    TableSchema tableSchema;
    CreateIndexWrap createIndexWrap;

    public CreateIndexSchemaClause(Class entityClass) {
        this(new MySQLDialect(),entityClass);
    }

    public CreateIndexSchemaClause(Dialect dialect, Class entityClass) {
        super(dialect);
        this.entityClass = entityClass;
        tableSchema= EntityMapping.getTableSchema(entityClass);
    }

    @Override
    public String getSql() {
        org.hibernate.dialect.Dialect hibernateDialect = DialectFactory.getHibernateDialect(dialect);
        createIndexWrap=new CreateIndexWrap(tableSchema,hibernateDialect);
        return createIndexWrap.getSql();
    }

    @Override
    public String getPlaceholderSql(List sqlParas) {
        return getSql();
    }

    @Override
    public String getNameParamSql(Map sqlParas) {
        return getSql();
    }

    public CreateIndexWrap getCreateIndexWrap() {
        return createIndexWrap;
    }

    public void setCreateIndexWrap(CreateIndexWrap createIndexWrap) {
        this.createIndexWrap = createIndexWrap;
    }
}
