package org.jsmth.data.sql;

import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.sql.wrap.IWhereWrap;
import org.jsmth.data.sql.wrap.WhereWrap;

import java.util.List;
import java.util.Map;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/3/8.
 */
public class AbstractWhereEntitySql extends AbstractEntitySql {
    protected WhereWrap wrapWhere;

    public AbstractWhereEntitySql(Dialect dialect) {
        super(dialect);
        wrapWhere=new WhereWrap();
    }

    public AbstractWhereEntitySql() {
        this(new MySQLDialect());
    }


    public void setWhereWrapInterface(IWhereWrap whereWrap) {
        this.wrapWhere = (WhereWrap) whereWrap;
    }
//
    public String getWhereBaseSql() {
        String sql = wrapWhere.getSql();
        if(sql.length()>0){
            sql=" WHERE "+sql;
        }
        return sql;
    }
//
    public String getWherePlaceholderSql(List sqlParas) {
        String sql = wrapWhere.getPlaceholderSql(sqlParas);
        if(sql.length()>0){
            sql=" WHERE "+sql;
        }
        return sql;
    }
//
    public String getWhereNameParamSql(Map sqlParas) {
        String sql = wrapWhere.getNameParamSql(sqlParas);
        if(sql.length()>0){
            sql=" WHERE "+sql;
        }
        return sql;
    }


    public WhereWrap getWrapWhere() {
        return wrapWhere;
    }

    public void setWrapWhere(WhereWrap wrapWhere) {
        this.wrapWhere = wrapWhere;
    }

//    public NameParameterWhereWrap getNameParameterWhereWrap() {
//        return nameParameterWhereWrap;
//    }
//
//    public void setNameParameterWhereWrap(NameParameterWhereWrap nameParameterWhereWrap) {
//        this.nameParameterWhereWrap = nameParameterWhereWrap;
//    }
//
//    public PlaceholderParameterWhereWrap getPlaceholderParameterWhereWrap() {
//        return placeholderParameterWhereWrap;
//    }
//
//    public void setPlaceholderParameterWhereWrap(PlaceholderParameterWhereWrap placeholderParameterWhereWrap) {
//        this.placeholderParameterWhereWrap = placeholderParameterWhereWrap;
//    }
}
