package org.jsmth.data.service;

import org.jsmth.data.dao.IEntityDao;
import org.jsmth.domain.Identifier;
import org.jsmth.domain.SearchCondition;
import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.page.Page;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
public interface IEntityService<KEY extends Serializable,
        MODEL extends Identifier<KEY>,
        ENTITYDAO extends IEntityDao<KEY, MODEL>> {

    String getNameById(KEY id);
    Object getPropertyById(KEY id,String propertyName);
    Object getPropertyById(KEY id,String propertyName,Object defaultValue);
    String getStrPropertyById(KEY id,String propertyName);
    String getStrPropertyById(KEY id,String propertyName,String defaultValue);
    int getIntPropertyById(KEY id,String propertyName);
    int getIntPropertyById(KEY id,String propertyName,int defaultValue);
    long getLongPropertyById(KEY id,String propertyName);
    long getLongPropertyById(KEY id,String propertyName,long defaultValue);

    MODEL save(MODEL model);

    MODEL insert(MODEL model);

    int update(MODEL model);

    int delete(MODEL model);

    int deleteById(KEY id);

    MODEL getById(KEY id);

    ENTITYDAO getEntityDao();

    void setEntityDao(ENTITYDAO entitydao);

    MODEL getByIdOrNew(KEY id) throws SmthDataAccessException;

    MODEL getByIdOrNew(KEY id, boolean insert) throws SmthDataAccessException;

    List<KEY> findIds();

    Page<KEY> pageIds(int pageNumber, int pageSize);

    List<MODEL> findAll();

    Page<MODEL> findAll(int pageNumber, int pageSize);

    List<MODEL> findByIds(List<KEY> ids) throws SmthDataAccessException;

    List<MODEL> findByIdsOrNew(List<? extends KEY> ids);

    int deleteByIds(Collection<? extends KEY> ids) throws SmthDataAccessException;

    Class getKeyClass();

    <K extends Serializable> void setBeginKey(K beginKey,boolean isdelete,Class... entityClasss);

    Page<MODEL> pageByCondition(int pageNumber, int pageSize, boolean totalRecord, SearchCondition condition);
    List<MODEL> findByCondition(SearchCondition condition) ;
    MODEL getByCondition(SearchCondition condition);
    List<KEY> findIdsByCondition(SearchCondition condition);
    <K extends Serializable> List<K> findColumnsByCondition(Class<K> kClass, String columnName, SearchCondition condition);
    <K extends Serializable> Page<K> pageColumnsByCondition(int pageNumber, int pageSize, boolean totalRecord,Class<K> kClass, String columnName, SearchCondition condition);




}
