package org.jsmth.data.service;

import org.jsmth.data.dao.*;
import org.jsmth.data.jdbc.JdbcDao;
import org.jsmth.domain.Identifier;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
public class EntityReadWriteDaoService<KEY extends Serializable,
        MODEL extends Identifier<KEY>>
        extends EntityDaoService<KEY, MODEL>
        implements IEntityReadWriteDaoService<KEY, MODEL> {
    //    @Override
    public JdbcDao getMasterJdbcDao() {
        return getJdbcDao();
    }

    public void setMasterJdbcDao(JdbcDao masterJdbcDao) {
        setJdbcDao(masterJdbcDao);
        if (entityDao != null) {
            entityDao.setJdbcDao(jdbcDao);
            if (entityDao.getClass().isAssignableFrom(ReadWriteEntityDao.class)) {
                ReadWriteEntityDao d = (ReadWriteEntityDao) entityDao;
                d.setMasterJdbcDao(jdbcDao);
                if (d.getSlaveJdbcDao() == null) {
                    d.setSlaveJdbcDao(jdbcDao);
                }
            }
        }
    }

    //    @Override
    public JdbcDao getSlaveJdbcDao() {
        if (entityDao != null) {
            entityDao.setJdbcDao(jdbcDao);
            if (ReadWriteEntityDao.class.isAssignableFrom(entityDao.getClass())) {
                ReadWriteEntityDao d = (ReadWriteEntityDao) entityDao;
                return d.getSlaveJdbcDao();
            }
        }
        return null;
    }

    public void setSlaveJdbcDao(JdbcDao slaveJdbcDao) {
        if (entityDao != null) {
            if (ReadWriteEntityDao.class.isAssignableFrom(entityDao.getClass())) {
                ReadWriteEntityDao d = (ReadWriteEntityDao) entityDao;
                d.setSlaveJdbcDao(slaveJdbcDao);
            }
        }
    }

    public EntityReadWriteDaoService(Class<MODEL> entityClass, Class<IEntityDao<KEY, MODEL>> iEntityDaoClass) {
        super(entityClass, iEntityDaoClass);
        entityDao = new DefaultReadWriteEntityDao<KEY, MODEL>(entityClass);
        entityDao.setEntityEventCallback(this);
    }

    public EntityReadWriteDaoService(Class<MODEL> entityClass) {
        super(entityClass);
        entityDao = new DefaultReadWriteEntityDao<KEY, MODEL>(entityClass);
        entityDao.setEntityEventCallback(this);
    }


}
