package org.jsmth.data.service;

import org.jsmth.data.dao.DefaultEntityDao;
import org.jsmth.data.dao.DefaultReadWriteEntityDao;
import org.jsmth.data.dao.IEntityDao;
import org.jsmth.data.dao.ReadWriteEntityDao;
import org.jsmth.data.jdbc.JdbcDao;
import org.jsmth.domain.Identifier;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
public class EntityReadWriteDaoCacheableService<KEY extends Serializable,
        MODEL extends Identifier<KEY>>
        extends EntityDaoCacheableService<KEY, MODEL>
        implements IEntityReadWriteDaoCacheableService<KEY, MODEL> {
    JdbcDao slaveJdbcDao;

    //    @Override
    public JdbcDao getMasterJdbcDao() {
        return getJdbcDao();
    }

    public void setMasterJdbcDao(JdbcDao masterJdbcDao) {
        setJdbcDao(masterJdbcDao);
        if (entityDao != null) {
            entityDao.setJdbcDao(jdbcDao);
            if (ReadWriteEntityDao.class.isAssignableFrom(entityDao.getClass())) {
                ReadWriteEntityDao d = (ReadWriteEntityDao) entityDao;
                d.setMasterJdbcDao(jdbcDao);
                if (d.getSlaveJdbcDao() == null) {
                    d.setSlaveJdbcDao(jdbcDao);
                }
            }
        }
    }

    //    @Override
    public JdbcDao getSlaveJdbcDao() {
        return slaveJdbcDao;
    }

    public void setSlaveJdbcDao(JdbcDao slaveJdbcDao) {
        this.slaveJdbcDao = slaveJdbcDao;
        if (entityDao != null) {
            if (ReadWriteEntityDao.class.isAssignableFrom(entityDao.getClass())) {
                ReadWriteEntityDao d = (ReadWriteEntityDao) entityDao;
                d.setSlaveJdbcDao(slaveJdbcDao);
            }
        }
    }


    public EntityReadWriteDaoCacheableService(Class<MODEL> entityClass, Class<IEntityDao<KEY, MODEL>> iEntityDaoClass) {
        super(entityClass, iEntityDaoClass);
        entityDao = new DefaultReadWriteEntityDao<KEY, MODEL>(entityClass);
        entityDao.setEntityEventCallback(this);
    }

    public EntityReadWriteDaoCacheableService(Class<MODEL> entityClass) {
        super(entityClass);
        entityDao = new DefaultReadWriteEntityDao<KEY, MODEL>(entityClass);
        entityDao.setEntityEventCallback(this);
    }


}
