package org.jsmth.data.service;

import org.jsmth.data.dao.DefaultEntityDao;
import org.jsmth.data.dao.DefaultReadWriteEntityDao;
import org.jsmth.data.dao.IEntityDao;
import org.jsmth.data.dao.ReadWriteEntityDao;
import org.jsmth.data.jdbc.JdbcDao;
import org.jsmth.domain.Identifier;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
public class EntityDaoService<KEY extends Serializable,
        MODEL extends Identifier<KEY>>
        extends EntityService<KEY,MODEL,IEntityDao<KEY,MODEL>>
        implements IEntityDaoService<KEY, MODEL> {

    protected JdbcDao jdbcDao;

    public EntityDaoService(Class<MODEL> entityClass, Class<IEntityDao<KEY, MODEL>> daoClass) {
        Constructor<?>[] constructors = daoClass.getConstructors();
        for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(entityClass.getClass())) {
                try {
                    entityDao = (IEntityDao<KEY, MODEL>) constructor.newInstance(entityClass);
                } catch (InstantiationException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        if (entityDao == null) {
            entityDao = new DefaultEntityDao<KEY, MODEL>(entityClass);
        }
    }


    public EntityDaoService(Class<MODEL> entityClass) {
        entityDao =new DefaultEntityDao<KEY,MODEL>(entityClass);
    }

    public JdbcDao getJdbcDao() {
        return jdbcDao;
    }

    public void setJdbcDao(JdbcDao jdbcDao) {
        this.jdbcDao = jdbcDao;
        if(entityDao!=null){
            entityDao.setJdbcDao(jdbcDao);
        }
    }
}
