package org.jsmth.data.schema;

import javassist.Modifier;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.jsmth.jorm.jdbc.schema.ColumnSchema;
import org.jsmth.jorm.jdbc.schema.TableSchema;
import org.springframework.dao.DataAccessException;

import javax.persistence.*;
import java.lang.reflect.Field;
import java.util.*;

/**
 * User: 马生录（mason
 * Date: 14-3-25
 * Time: 上午9:33
 */
public class EntityMapping {

    static Map<Class, TableSchema> tableSchemaMap = new LinkedHashMap<Class, TableSchema>();

    public static TableSchema getTableSchema(Class entityClass) {
        if (tableSchemaMap.containsKey(entityClass)) {
            return tableSchemaMap.get(entityClass);
        }
        TableSchema tableSchema = EntityMapping.getTable(entityClass);
        tableSchemaMap.put(entityClass, tableSchema);
        return tableSchema;
    }

    public EntityMapping() {
    }

    public static TableSchema getTable(Class<?> entityClass) {
        if (!TableSchema.isEntity(entityClass)) {
            throw new IllegalArgumentException("not a pojo entity object of "+entityClass.getName());
        }
        TableSchema tableSchema = new TableSchema(entityClass);
        buildCollumns(tableSchema);
        return tableSchema;
    }

    public static void buildCollumns(TableSchema tableSchema) {
        List<ColumnSchema> columnSchemas = getClassCollumns(tableSchema.getEntityClass(), null);
        for (ColumnSchema columnSchema : columnSchemas) {
            tableSchema.addColumn(columnSchema);
        }
        for (ColumnSchema columnSchema : tableSchema.getEmbeddedColumnss()) {
            AttributeOverrides attributeOverrides = columnSchema.getField().getAnnotation(AttributeOverrides.class);
            if (attributeOverrides != null) {
                for (AttributeOverride attributeOverride : attributeOverrides.value()) {
                    tableSchema.updateColumnName(attributeOverride.name(),attributeOverride.column().name());
                }
            }
        }
        if (tableSchema.getIdColumn() == null) {
            throw new IllegalArgumentException("entity not id field.");
        }
    }

    public static List<ColumnSchema> getClassCollumns(Class entityClass, ColumnSchema embededColumnSchema) {
        List<ColumnSchema> columnSchemas = new LinkedList<ColumnSchema>();
        List<Field> jpaFields = getJPAFields(entityClass);
        for (Field jpaField : jpaFields) {
            if (jpaField.getAnnotation(Embedded.class) != null) {
                if (embededColumnSchema != null) {
                    throw new IllegalArgumentException("not support > two level embedded.");
                }
                ColumnSchema columnSchema = new ColumnSchema(jpaField);
                columnSchema.setEmbedded(true);
                columnSchemas.add(columnSchema);
                List<ColumnSchema> classCollumns = getClassCollumns(jpaField.getType(), columnSchema);
                columnSchemas.addAll(classCollumns);


            } else if (jpaField.getAnnotation(EmbeddedId.class) != null) {
                if (embededColumnSchema != null) {
                    throw new IllegalArgumentException("not support > two level embeddedId.");
                }
                ColumnSchema columnSchema = new ColumnSchema(jpaField);
                columnSchema.setEmbedded(true);
                columnSchemas.add(columnSchema);
                List<ColumnSchema> classCollumns = getClassCollumns(jpaField.getType(), columnSchema);
                columnSchemas.addAll(classCollumns);


            } else {
                ColumnSchema columnSchema = new ColumnSchema(jpaField);
                if (embededColumnSchema != null) {
                    columnSchema.setEmbedding(true);
                    columnSchema.setEmbeddedColumn(embededColumnSchema);
                }
                columnSchemas.add(columnSchema);
            }
        }
        return columnSchemas;
    }

    public static org.hibernate.mapping.Table getHMapingTable(Configuration cfg, Dialect dialect) throws DataAccessException {
        org.hibernate.mapping.Table table = cfg.getTableMappings().next();
        Mapping mapping = cfg.buildMapping();
        table.sqlCreateString(dialect, mapping, cfg.getProperties().getProperty(Environment.DEFAULT_CATALOG), cfg.getProperties().getProperty(Environment.DEFAULT_SCHEMA));
        return table;
    }

    /**
     * 获得所有JPA属性的列表，并且将父类的放在前面
     *
     * @param clazz ff
     * @param <T> ff
     * @return 返回信息
     */
    public static <T> List<Field> getJPAFields(Class<T> clazz) {
        Class superclazz = clazz;
        List<Field> tmp = new ArrayList<Field>();

        while (superclazz != null && !superclazz.equals(Object.class)) {
            Field[] fields = superclazz.getDeclaredFields();

            List<Field> tmp2 = new ArrayList<Field>();

            for (Field field : fields) {
                //排除肯定不持久化的部分
                if (Modifier.isTransient(field.getModifiers())) continue;
                if (Modifier.isStatic(field.getModifiers())) continue;
                if (field.getAnnotation(Transient.class) != null) continue;
                tmp2.add(field);
            }
            tmp.addAll(0, tmp2);
            superclazz = superclazz.getSuperclass();
        }
        List<Field> result = new LinkedList<Field>();
        List<Field> lobs = new ArrayList<Field>();
        for (Field field : tmp) {
//            Validate.isTrue(validJPAType(field), "invalid JPA type for field [" + field + "]");
            Lob lob = field.getAnnotation(Lob.class);
            if (lob == null)
                result.add(field);
            else
                lobs.add(field);
        }
        for (Field lob : lobs) {
            result.add(lob);
        }
        return tmp;
    }

    public void buildCollumn() {

    }

    /**
     * 检查类属性是否为JPA标准的简单类型，并且不能使用@embedded
     *
     * @param field ff
     * @return 返回信息
     */
    public static boolean validJPAType(Field field) {
        return field.getAnnotation(Embedded.class) == null;
    }


}
