package org.jsmth.data.redis;

import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

import java.io.Serializable;
import java.lang.reflect.Type;

/**
 * Created by mason on 16/1/3.
 */
public class RedisKeySerializerFactory {

    public static  RedisSerializer createRedisSerializer(Type keyClassType) {
        return createRedisSerializer(keyClassType.getClass());
    }
        public static  RedisSerializer createRedisSerializer(Class<? extends Serializable> keyClass){
        if(String.class.isAssignableFrom(keyClass)){
            return new StringRedisSerializer();
        }
        if(Integer.class.isAssignableFrom(keyClass)){
            return new IntRedisSerializer();
        }
        if(Long.class.isAssignableFrom(keyClass)){
            return new LongRedisSerializer();
        }
        return null;
    }
}
