package org.jsmth.data.redis;

import org.jsmth.domain.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

import java.io.*;

/**
 * Created by mason on 15/12/31.
 */
public class RedisEntitySerialize<KEY extends Serializable, MODEL extends Identifier<KEY>>
    implements RedisSerializer<MODEL>
{
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public byte[] serialize(MODEL model) throws SerializationException {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        try {
            // 序列化
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(model);
            byte[] bytes = baos.toByteArray();
            return bytes;
        } catch (Exception e) {
            log.error("RedisEntitySerialize serialize error",e);
        }
        return null;
    }

    @Override
    public MODEL deserialize(byte[] bytes) throws SerializationException {
        ByteArrayInputStream bais = null;
        try {
            // 反序列化
            bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (MODEL)ois.readObject();
        } catch (Exception e) {
            log.error("RedisEntitySerialize deserialize error",e);
        }
        return null;
    }
}
