package org.jsmth.data.redis;

import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

import java.nio.charset.Charset;

/**
 * Created by mason on 16/1/3.
 */
public class LongRedisSerializer implements RedisSerializer<Long> {

    private final Charset charset;

    public LongRedisSerializer() {
        this(Charset.forName("UTF8"));
    }

    public LongRedisSerializer(Charset charset) {
        Assert.notNull(charset);
        this.charset = charset;
    }

    public Long deserialize(byte[] bytes) {
        return (bytes == null ? 0 : Long.parseLong(new String(bytes)));
    }

    public byte[] serialize(Long value) {
        return (value == null ? new byte[0] : value.toString().getBytes());
    }
}
