package org.jsmth.data.redis;

import com.google.gson.Gson;
import org.jsmth.domain.Identifier;
import org.jsmth.util.ReflectUtil;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

/**
 * Created by mason on 16/1/3.
 */
public class JasonEntityRedisSerializer<KEY extends Serializable, MODEL extends Identifier<KEY>> implements RedisSerializer<MODEL> {

    private final Charset charset;

    public JasonEntityRedisSerializer() {
        this(Charset.forName("UTF8"));
    }

    public JasonEntityRedisSerializer(Charset charset) {
        Assert.notNull(charset);
        this.charset = charset;
    }

    public MODEL deserialize(byte[] bytes) {
        if(bytes==null){
            return null;
        }
        String content=new String(bytes,charset);
        Gson gson=new Gson();
        return  gson.fromJson(content,getEntityClassType());
    }
    public byte[] serialize(MODEL value) {
        if (value == null)
                return new byte[0];
        Gson gson=new Gson();
        String content = gson.toJson(value);
        return content.getBytes();
    }

    public Type getKeyClassType(){
        return ReflectUtil.getGenericClassParameterizedType(this.getClass(), 0);
    }
    public Type getEntityClassType(){
        return ReflectUtil.getGenericClassParameterizedType(this.getClass(),1);
    }
}
