package org.jsmth.data.redis;

import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

import java.nio.charset.Charset;

/**
 * Created by mason on 16/1/3.
 */
public class IntRedisSerializer implements RedisSerializer<Integer> {

    private final Charset charset;

    public IntRedisSerializer() {
        this(Charset.forName("UTF8"));
    }

    public IntRedisSerializer(Charset charset) {
        Assert.notNull(charset);
        this.charset = charset;
    }

    public Integer deserialize(byte[] bytes) {
        return (bytes == null ? 0 : Integer.parseInt(new String(bytes)));
    }

    public byte[] serialize(Integer value) {
        return (value == null ? new byte[0] : value.toString().getBytes());
    }
}
