package org.jsmth.data.jdbc.conf;

import org.jsmth.data.dialect.DialectType;

/**
 * Created by mason on 16/1/5.
 */
public class SQLiteJdbcConfig extends CommonJdbcConfig {
    public SQLiteJdbcConfig() {
        this.driverClassName="org.sqlite.JDBC";
        this.dialectType= DialectType.SQLite;
    }
    @Override
    public String buildUrl(String host, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:sqlite:");
        url.append(database);
        return url.toString();
    }
}
