package org.jsmth.data.jdbc.conf;

import org.jsmth.data.dialect.DialectType;

/**
 * Created by mason on 16/1/5.
 */
public class SQLServerJdbcConfig extends CommonJdbcConfig {
    public SQLServerJdbcConfig() {
        this.driverClassName="com.microsoft.sqlserver.jdbc.SQLServerDriver";
        this.dialectType= DialectType.SQLServer;
    }
    @Override
    public String buildUrl(String host, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:sqlserver://");
        url.append(host);
        if(port==0){
            port=1433;
        }
        url.append(":");
        url.append(port);
        url.append("; DatabaseName=");
        url.append(database);
        return url.toString();
    }
}
