package org.jsmth.data.jdbc.conf;

import org.jsmth.data.dialect.DialectType;

/**
 * Created by mason on 16/1/5.
 */
public class PostgreSQLJdbcConfig extends CommonJdbcConfig {
    public PostgreSQLJdbcConfig() {
        this.driverClassName="org.postgresql.Driver";
        this.dialectType= DialectType.PostgreSQL;
    }

    @Override
    public String buildUrl(String host, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:postgresql://");
        url.append(host);
        if(port==0){
            port=5432;
        }
        url.append(":");
        url.append(port);
        url.append("/");
        url.append(database);
        return url.toString();
    }
}
