package org.jsmth.data.jdbc.conf;

import org.jsmth.data.dialect.DialectType;

/**
 * Created by mason on 16/1/5.
 */
public class OracleJdbcConfig extends CommonJdbcConfig {
    public OracleJdbcConfig() {
        this.driverClassName="oracle.jdbc.driver.OracleDriver";
        this.dialectType= DialectType.Oracle;
    }
    @Override
    public String buildUrl(String host, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:oracle:thin:@");
        url.append(host);
        if(port==0){
            port=1521;
        }
        url.append(":");
        url.append(port);
        url.append(":");
        url.append(database);
        return url.toString();
    }
}
