package org.jsmth.data.jdbc.conf;

import org.jsmth.data.dialect.DialectType;

/**
 * Created by mason on 16/1/5.
 */
public class MySQLJdbcConfig extends CommonJdbcConfig {
    public MySQLJdbcConfig() {
        this.driverClassName="com.mysql.jdbc.Driver";
        this.dialectType= DialectType.MySQL;
    }

    @Override
    public String buildUrl(String host, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:mysql://");
        url.append(host);
        if(port==0){
            port=3306;
        }
        url.append(":");
        url.append(port);
        url.append("/");
        url.append(database);
        url.append("?useUnicode=true&amp;characterEncoding=utf-8&amp;autoReconnect=true&amp;autoReconnectForPools=true");
        return url.toString();
    }
}
