package org.jsmth.data.jdbc.conf;

import org.jsmth.data.dialect.DialectType;

/**
 * Created by mason on 16/1/5.
 */
public class HSQLJdbcConfig extends CommonJdbcConfig {
    public HSQLJdbcConfig() {
        this.driverClassName="org.hsqldb.jdbcDriver";
        this.dialectType= DialectType.HSQL;
    }

    @Override
    public String buildUrl(String host, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:hsqldb:mem:.");


        //jdbc:hsqldb:mem:.
        //jdbc:hsqldb:file:E:/hsqldb/data/mydb
        //jdbc:hsqldb:hsql://localhost:PORT/DB_NAME);
        return url.toString();
    }
}
