package org.jsmth.data.jdbc.conf;

import org.jsmth.data.dialect.DialectType;

/**
 * Created by mason on 16/1/5.
 */
public class Db2JdbcConfig extends CommonJdbcConfig {
    public Db2JdbcConfig() {
        this.driverClassName="com.ibm.db2.jcc.DB2Driver";
        this.dialectType= DialectType.Db2;
    }

    @Override
    public String buildUrl(String host, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:db2://");
        url.append(host);
        if(port==0){
            port=50000;
        }
        url.append(":");
        url.append(port);
        url.append("/");
        url.append(database);
        return url.toString();
    }
}
