package org.jsmth.data.jdbc.conf;

import org.jsmth.data.dialect.DialectType;

/**
 * Created by mason on 16/1/5.
 */
public class CommonJdbcConfig implements JdbcConfig {
    DialectType dialectType;
    protected String url;
    protected String username;
    protected String password;
    protected String driverClassName;
    protected String driverProxyClassName;
    String validationQuery="select 1";

    public CommonJdbcConfig() {
    }
    public CommonJdbcConfig(String host,int port,String database, String userName, String password, String driverClassName) {
        this("",userName,password, driverClassName);
        this.url=buildUrl(host,port, database);
    }
    public CommonJdbcConfig(String url, String userName, String password, String driverClassName) {
        this.url = url;
        this.username = userName;
        this.password = password;
        this.driverClassName = driverClassName;
    }
    public String buildUrl(String host,String database){
        return buildUrl(host,0,database);
    }
    public String buildUrl(String host,int port,String database){
        return "";
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverClassName() {
        return driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getDriverProxyClassName() {
        return driverProxyClassName;
    }

    public void setDriverProxyClassName(String driverProxyClassName) {
        this.driverProxyClassName = driverProxyClassName;
    }

    public DialectType getDialectType() {
        return dialectType;
    }

    public void setDialectType(DialectType dialectType) {
        this.dialectType = dialectType;
    }

    public String getValidationQuery() {
        return validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }
}
