package org.jsmth.data.jdbc;

import org.apache.commons.dbcp.BasicDataSource;
import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.DialectFactory;
import org.jsmth.data.schema.ObjectTableMeta;
import org.jsmth.data.sql.*;
import org.jsmth.data.sql.item.CreateIndexItem;
import org.jsmth.data.sql.item.DropIndexItem;
import org.jsmth.data.sql.item.PageableItem;
import org.jsmth.data.sql.sqlbuilder.Query;
import org.jsmth.data.sql.wrap.*;
import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.exception.SmthExceptionDict;
import org.jsmth.jorm.jdbc.*;
import org.jsmth.page.CommonPage;
import org.jsmth.page.Page;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;

import javax.annotation.PostConstruct;
import javax.persistence.MappedSuperclass;
import javax.sql.DataSource;
import java.sql.*;
import java.util.*;

/**
 * Created by mason on 15/12/25.
 */
@MappedSuperclass
public class TableJdbcDao extends BaseJdbcDao implements ITableJdbcDao {
    protected EntityEventCallback entityEventCallback;

    public TableJdbcDao(DataSource dataSource) {
        super(dataSource);
    }

    public TableJdbcDao(SmthDataSource dataSource) {
        super(dataSource);
    }

    public TableJdbcDao(DataSource dataSource, String dialectString) {
        super(dataSource, dialectString);
    }

    public TableJdbcDao(DataSource dataSource, Dialect dialect) {
        super(dataSource, dialect);
    }

    @PostConstruct
    public void init() {
        super.init();
//        Validate.notNull(dataSource, "datasource must be set!");
//        Validate.notNull(jdbcTemplate, "entity dao must be set!");
//        Validate.notNull(dialect, "entity dao must be set!");
    }
    //<editor-fold desc="update">
    public <T> int update(Class<T> entityClass, UpdateFieldWrap updateFieldWrap, IWhereWrap whereWrap) {
        EntityUpdate entityUpdate = new EntityUpdate(entityClass, dialect);
        entityUpdate.setWhereWrapInterface(whereWrap);
        entityUpdate.setWrapUpdateField(updateFieldWrap);
        return update(entityClass, entityUpdate);
    }

    public <T> int update(Class<T> entityClass, EntityUpdate entityUpdate) {
        entityUpdate.setDialect(dialect);
        if (entityUpdate.getWrapWhere().getSqlQueryType() == SqlQueryType.SQL) {
            List sqlParas = new LinkedList<>();
            String sql = entityUpdate.getPlaceholderSql(sqlParas);
            try {
                return update(sql);
            }catch (Exception ex){
                ex.printStackTrace();
                return 0;
            }
        }
        if (entityUpdate.getWrapWhere().getSqlQueryType() == SqlQueryType.Placeholder) {
            List sqlParas = new LinkedList<>();
            String sql = entityUpdate.getPlaceholderSql(sqlParas);
            try {
                return update(sql, sqlParas.toArray());
            }catch (Exception ex){
                ex.printStackTrace();
                return 0;
            }
        }
        if (entityUpdate.getWrapWhere().getSqlQueryType() == SqlQueryType.NameParam) {
            Map sqlParas = new LinkedHashMap<>();
            String sql = entityUpdate.getNameParamSql(sqlParas);
            try {
                return update(sql, sqlParas);
            }catch (Exception ex){
                ex.printStackTrace();
                return 0;
            }
        }
        return 0;
    }
//    public <T> int update(T model, EntityUpdate entityUpdate) {
//        entityUpdate.setDialect(dialect);
//        if(entityUpdate.getSqlQueryType()==SqlQueryType.SQL){
//            List sqlParas=new LinkedList<>();
//            String sql = entityUpdate.getPlaceholderSql(sqlParas);
//            return getJdbcOperations().update(sql);
//        }
//        if(entityUpdate.getSqlQueryType()==SqlQueryType.Placeholder){
//            List sqlParas=new LinkedList<>();
//            String sql = entityUpdate.getPlaceholderSql(sqlParas);
//            return getJdbcOperations().update(sql, sqlParas.toArray());
//        }
//        if(entityUpdate.getSqlQueryType()==SqlQueryType.NameParam){
//            Map sqlParas=new LinkedHashMap<>();
//            String sql = entityUpdate.getNameParamSql(sqlParas);
//            return update(sql, sqlParas);
//        }
//        return 0;
//    }

    public <T> int updateModel(T model, UpdateFieldWrap updateFieldWrap, IWhereWrap whereWrap) {
        EntityUpdate entityUpdate = new EntityUpdate(model.getClass(), dialect);
        entityUpdate.setWhereWrapInterface(whereWrap);
        entityUpdate.setWrapUpdateField(updateFieldWrap);
//        Map sqlParas = new HashMap<>();
//        String nameParamSql = entityUpdate.getNameParamSql(sqlParas);
//        int update = update(nameParamSql, new BeanPropertySqlParameterSourceEx(model));
        List sqlParas=new ArrayList<>();

        BeanPropertySqlParameterSourceEx parameterSourceEx = new BeanPropertySqlParameterSourceEx(model);

        String sql = entityUpdate.getPlaceholderSql(sqlParas);
        try {
            int update = update(sql, sqlParas.toArray());
            return update;
        }catch (Exception ex){
            ex.printStackTrace();
            return 0;
        }
    }

    public <T> int updateField(T model, UpdateFieldWrap updateFieldWrap, IWhereWrap whereWrap) {
        EntityUpdate entityUpdate = new EntityUpdate(model.getClass(), dialect);
        entityUpdate.setWhereWrapInterface(whereWrap);
        entityUpdate.setWrapUpdateField(updateFieldWrap);
        Map sqlParas = new HashMap<>();
        String nameParamSql = entityUpdate.getNameParamSql(sqlParas);
        try {
            int update = update(nameParamSql, new BeanPropertySqlParameterSourceEx(model));
            return update;
        }catch (Exception ex){
            ex.printStackTrace();
            return 0;
        }
    }

    //</editor-fold>
    //<editor-fold desc="delete">
    public <T> int delete(Class<T> entityClass, IWhereWrap whereWrap) {
        EntityDelete entityDelete = new EntityDelete(entityClass, dialect);
        entityDelete.setWhereWrapInterface(whereWrap);
        return delete(entityDelete);
    }


    public <T> int delete(EntityDelete entityDelete) {
        entityDelete.setDialect(dialect);

        if (entityDelete.getWrapWhere().getSqlQueryType() == SqlQueryType.SQL) {
            List sqlParas = new LinkedList<>();
            String sql = entityDelete.getPlaceholderSql(sqlParas);
            try {
                return update(sql);
            }catch (Exception ex){
                ex.printStackTrace();
                return 0;
            }
        }
        if (entityDelete.getWrapWhere().getSqlQueryType() == SqlQueryType.Placeholder) {
            List sqlParas = new LinkedList<>();
            String sql = entityDelete.getPlaceholderSql(sqlParas);
            try {
                return update(sql, sqlParas.toArray());
            }catch (Exception ex){
                ex.printStackTrace();
                return 0;
            }
        }
        if (entityDelete.getWrapWhere().getSqlQueryType() == SqlQueryType.NameParam) {
            Map sqlParas = new LinkedHashMap<>();
            String sql = entityDelete.getNameParamSql(sqlParas);
            try {
                return update(sql, sqlParas);
            }catch (Exception ex){
                ex.printStackTrace();
                return 0;
            }
        }
        return 0;
    }

    //</editor-fold>
    //<editor-fold desc="insert">
    public <T> Number insertBackKey(Class<T> entityClass, InsertFieldWrap insertFieldWrap, InsertValueWrap insertValueWrap) {
        EntityInsert entityInsert = new EntityInsert(entityClass, dialect);
        entityInsert.setWrapInsertField(insertFieldWrap);
        entityInsert.setWrapInsertValue(insertValueWrap);
        Map sqlParas = new HashMap<>();
        String nameParamSql = entityInsert.getNameParamSql(sqlParas);
//        String nameParamSql = entityInsert.getSql();
        KeyHolder keyholder = new GeneratedKeyHolder();
        try {
            int update = update(nameParamSql, new MapSqlParameterSourceEx(sqlParas), keyholder);
            if (update > 0) {
                return keyholder.getKey();
            } else {
                return null;
            }
        }catch (Exception ex){
            ex.printStackTrace();
            return null;
        }
    }

    public <T> int insert(Class<T> entityClass, InsertFieldWrap insertFieldWrap, InsertValueWrap insertValueWrap) {
        EntityInsert entityInsert = new EntityInsert(entityClass, dialect);
        entityInsert.setWrapInsertField(insertFieldWrap);
        entityInsert.setWrapInsertValue(insertValueWrap);
        Map sqlParas = new HashMap<>();
        String nameParamSql = entityInsert.getNameParamSql(sqlParas);
        try {
            return executeNoQuery(nameParamSql, sqlParas);
        }catch (Exception ex){
            ex.printStackTrace();
            return 0;
        }
    }

    public <T> int insert(Class<T> entityClass, Map<String, Object> fieldValue) {
        InsertFieldWrap insertFieldWrap = new InsertFieldWrap();
        InsertValueWrap insertValueWrap = new InsertValueWrap();
        for (Map.Entry<String, Object> entry : fieldValue.entrySet()) {
            insertFieldWrap.f(entry.getKey(), "");
            insertValueWrap.v(entry.getKey(), entry.getValue());
        }
        try {
            return insert(entityClass, insertFieldWrap, insertValueWrap);
        }catch (Exception ex){
            ex.printStackTrace();
            return 0;
        }
    }
    //</editor-fold>
    //<editor-fold desc="queryAll">
    public <T> List<T> queryAll(Class<T> entityClass) {
        WhereWrap whereWrap = new WhereWrap();
        return query(entityClass, whereWrap);
    }

    public <T> Page<T> queryAllForPage(Class<T> entityClass, int pageNumber, int pageSize) {
        return queryPage(entityClass,pageNumber,pageSize,true,"*","");
    }

    //</editor-fold>
    //<editor-fold desc="query">
    public <T> List<T> query(Class<T> entityClass, IWhereWrap where) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.setWhereWrapInterface(where);
        return query(entityClass, query);
    }

    public <T> List<T> query(Class<T> tClass, EntityQuery query) {
        query.setDialect(dialect);
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.SQL) {
            List sqlParas = new LinkedList<>();
            String sql = query.getPlaceholderSql(sqlParas);
            return query(sql, new JPARowMapper<T>(tClass));
        }
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.Placeholder) {
            List sqlParas = new LinkedList<>();
            String sql = query.getPlaceholderSql(sqlParas);
            return   query(sql, sqlParas.toArray(), new JPARowMapper<T>(tClass));
        }
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.NameParam) {
            Map sqlParas = new LinkedHashMap<>();
            String sql = query.getNameParamSql(sqlParas);
            return query(sql, sqlParas, new JPARowMapper<T>(tClass));
        }
        return null;
    }

    @Override
    public <T> List<T> query(Class<T> entityClass, String select, String where, Object... params) {
        String sql = buildQuerySql(entityClass, select, where);
        return queryForEntityList(entityClass, sql,params);
    }

    //</editor-fold>
    //<editor-fold desc="for page">
    public <T> Page<T> queryPage(Class<T> entityClass, IWhereWrap where, int pageNumber, int pageSize) {
        return queryPage(entityClass, where, pageNumber, pageSize, false);
    }
    public <T> Page<T> queryPage(Class<T> entityClass, IWhereWrap where, int pageNumber, int pageSize, boolean totalRecord) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.setWhereWrapInterface(where);
        query.setPageableItem(new PageableItem(pageNumber, pageSize, totalRecord));
        return queryPage(entityClass, query);
    }

    @Override
    public <T> Page<T> queryPage(Class<T> entityClass, int pageNumber, int pageSize, boolean totalRecord, String select, String where, Object... params) {
        String sql = buildQuerySql(entityClass, "count(*)", where);
        Integer count = queryForObject(Integer.class, sql, params);
        sql = buildQuerySql(entityClass, "*", where);
        CommonPage<T> page=new CommonPage<>();
        page.setPageNumber(pageNumber);
        page.setPageSize(pageSize);
        page.setTotalItemsCount(count);
        Dialect dialect = DialectFactory.getDialect((BasicDataSource) getDataSource());
        sql = dialect.getLimitString(sql, pageNumber, pageSize);
        page.setItems(queryForEntityList(entityClass, sql,params));
        return page;
    }

    public <T> Page<T> queryPage(Class<T> entityClass, EntityQuery query) {
        query.setDialect(dialect);
        Map sqlParas = new HashMap<>();
        String sql = query.getNameParamSql(sqlParas);
        PageableItem pageableItem = query.getPageableItem();
        CommonPage<T> page = new CommonPage<>();
        if (pageableItem != null) {
            page.setPageNumber(pageableItem.getPageNumber());
            page.setPageSize(pageableItem.getPageSize());
            sql = dialect.getLimitString(sql, pageableItem.getPageNumber(), pageableItem.getPageSize());
            if (pageableItem.isTotalRecord()) {
                Map sqlParas2 = new HashMap<>();
                String totalSql = query.getPageNameParamSql(sqlParas2);
                totalSql = dialect.getLimitString(totalSql, pageableItem.getPageNumber(), pageableItem.getPageSize());
                int total = queryForInt(totalSql, sqlParas2);
                page.setTotalItemsCount(total);
            }
        }
        List<T> list = query(entityClass, query);
        page.setItems(list);
        return page;
    }

//    public <T> Page<T> queryPage(Query query) {
//        List<Object> sqlParas=new ArrayList<>();
//        String sql = query.query();
//        sqlParas=query.getSqlParas();
//        CommonPage<T> page = new CommonPage<>();
//        page.setPageNumber(query.getPageNumber());
//        page.setPageSize(query.getPageSize());
//        sql = dialect.getLimitString(sql, query.getPageNumber(), query.getPageSize());
//        if (query.isTotalRecord()) {
//            Query q=new Query(query.getClass());
//            q.sCount()
//            .where(query.getWhere()) ;
//            String totalSql = q.query();
//            int total = queryForInt(totalSql, q.getSqlParas());
//            page.setTotalItemsCount(total);
//    }
//        List<T> list = query(entityClass, query);
//        page.setItems(list);
//        return page;
//    }
    //</editor-fold>
    //<editor-fold desc="For number">
    public Number queryForNumber(String sql, Map<String, ?> paramMap) {
        return queryForNumber(sql, (SqlParameterSource) (new MapSqlParameterSource(paramMap)));
    }

    public Number queryForNumber(String sql, SqlParameterSource paramSource) {
        return (Number) queryForObject(sql, paramSource, Number.class);
    }

    public int queryForInt(String sql, Map<String, ?> paramMap) {
        Number number = queryForNumber(sql, paramMap);
        return number != null ? number.intValue() : 0;
    }

    public int queryForInt(String sql, SqlParameterSource paramSource) {
        Number number = queryForNumber(sql, paramSource);
        return number != null ? number.intValue() : 0;
    }

    public long queryForLong(String sql, Map<String, ?> paramMap) {
        Number number = queryForNumber(sql, paramMap);
        return number != null ? number.intValue() : 0L;
    }

    public long queryForLong(String sql, SqlParameterSource paramSource) {
        Number number = queryForNumber(sql, paramSource);
        return number != null ? number.intValue() : 0L;
    }
    //</editor-fold>
    //<editor-fold desc="for object">
    public <T> T queryForObject(Class<T> entityClass, IWhereWrap where) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.setWhereWrapInterface(where);
        return queryForObject(entityClass, query);
    }

    public <T> T queryForObject(Class<T> entityClass, EntityQuery query) {
        List<T> list = query(entityClass, query);
        if(list==null || list.size()==0){
            return null;
        }
        return list.get(0);
    }

    public <T> T queryForObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException {
        List<T> list = query(sql, paramMap, rowMapper);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }



    @Override
    public <T> int queryForInt(Class<T> entityClass, IWhereWrap where) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.setWhereWrapInterface(where);
        return queryForInt(entityClass, query);
    }


    @Override
    public <T> int queryForInt(Class<T> entityClass, EntityQuery query) {
        query.setDialect(dialect);
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.SQL) {
            List sqlParas = new LinkedList<>();
            String sql = query.getPlaceholderSql(sqlParas);
            return (Integer)queryForObject(sql, new SingleColumnRowMapper(Integer.class));
        }
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.Placeholder) {
            List sqlParas = new LinkedList<>();
            String sql = query.getPlaceholderSql(sqlParas);
            return (Integer)queryForObject(sql, sqlParas.toArray(), new SingleColumnRowMapper(Integer.class));
        }
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.NameParam) {
            Map sqlParas = new LinkedHashMap<>();
            String sql = query.getNameParamSql(sqlParas);
            return (Integer)queryForObject(sql, sqlParas, new SingleColumnRowMapper(Integer.class));
        }
        return 0;
    }


    //</editor-fold>
    //<editor-fold desc="for map">
    public Map<String, Object> queryForMap(Class<?> entityClass, IWhereWrap where) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.setWhereWrapInterface(where);
        return queryForMap(entityClass, query);
    }
    public Map<String, Object> queryForMap(Class<?> entityClass, String where, Object... params) {
        WhereWrap whereWrap = new WhereWrap();
        whereWrap.placeholderW(where, params);
        return queryForMap(entityClass, whereWrap);
    }

    public Map<String, Object> queryForMap(Class<?> entityClass, EntityQuery query) {
        query.setDialect(dialect);
        Map sqlParas = new HashMap<>();
        String sql = query.getNameParamSql(sqlParas);
        return queryForMap(sql, sqlParas);
    }
    //</editor-fold>
    //<editor-fold desc="for queryColumn">
    public <C> List<C> queryColumn(Class<?> entityClass, Class<C> cClass, String fieldName, IWhereWrap where) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.s(fieldName);
        query.setWhereWrapInterface(where);
        return queryColumn(cClass, query);
    }
    public <C> List<C> queryColumn(Class<?> entityClass, Class<C> cClass, String fieldName, String where, Object... params) {
        WhereWrap whereWrap = new WhereWrap();
        whereWrap.placeholderW(where, params);
        return queryColumn(entityClass, cClass,fieldName,whereWrap);
    }

    public <T> List<T> queryColumn(Class<T> tClass, EntityQuery query) {
        query.setDialect(dialect);
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.SQL) {
            List sqlParas = new LinkedList<>();
            String sql = query.getPlaceholderSql(sqlParas);
            return query(sql, new SingleColumnRowMapper<T>(tClass));
        }
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.Placeholder) {
            List sqlParas = new LinkedList<>();
            String sql = query.getPlaceholderSql(sqlParas);
            return query(sql, sqlParas.toArray(), new SingleColumnRowMapper<T>(tClass));
        }
        if (query.getWrapWhere().getSqlQueryType() == SqlQueryType.NameParam) {
            Map sqlParas = new LinkedHashMap<>();
            String sql = query.getNameParamSql(sqlParas);
            return query(sql, sqlParas, new SingleColumnRowMapper<T>(tClass));
        }
        return null;
    }
    //</editor-fold>
    //<editor-fold desc="for queryPageColumn">
    public <T, C> Page<C> queryPageColumn(Class<T> entityClass, Class<C> cClass, String columnName, IWhereWrap where, int pageNumber, int pageSize) {
        return queryPageColumn(entityClass, cClass, columnName, where, pageNumber, pageSize, false);
    }

    public <T, C> Page<C> queryPageColumn(Class<T> entityClass, Class<C> cClass, String columnName, IWhereWrap where, int pageNumber, int pageSize, boolean totalRecord) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.s(columnName);
        query.setWhereWrapInterface(where);
        query.setPageableItem(new PageableItem(pageNumber, pageSize, totalRecord));
        return queryPageColumn(cClass, query);
    }

    @Override
    public <T, C> Page<C> queryPageColumn(Class<T> entityClass, Class<C> cClass, String columnName, int pageNumber, int pageSize, boolean totalRecord, String where, Object... params) {
        String sql = buildQuerySql(entityClass, "count(*)", where);
        Integer count = queryForObject(Integer.class, sql, params);
        sql = buildQuerySql(entityClass, "*", where);
        CommonPage<C> page=new CommonPage<>();
        page.setPageNumber(pageNumber);
        page.setPageSize(pageSize);
        page.setTotalItemsCount(count);
        Dialect dialect = DialectFactory.getDialect((BasicDataSource) getDataSource());
        sql = dialect.getLimitString(sql, pageNumber, pageSize);
        page.setItems(queryForList(cClass, sql,params));
        return page;
    }


    public <C> Page<C> queryPageColumn(Class<C> cClass, EntityQuery query) {
        query.setDialect(dialect);
        Map sqlParas = new HashMap<>();
        String sql = query.getNameParamSql(sqlParas);
        PageableItem pageableItem = query.getPageableItem();
        CommonPage<C> page = new CommonPage<>();
        if (pageableItem != null) {
            page.setPageNumber(pageableItem.getPageNumber());
            page.setPageSize(pageableItem.getPageSize());
            sql = dialect.getLimitString(sql, pageableItem.getPageNumber(), pageableItem.getPageSize());
            if (pageableItem.isTotalRecord()) {
                Map sqlParas2 = new HashMap<>();
                String totalSql = query.getPageNameParamSql(sqlParas2);
                totalSql = dialect.getLimitString(totalSql, pageableItem.getPageNumber(), pageableItem.getPageSize());
                int total = queryForInt(totalSql, sqlParas2);
                page.setTotalItemsCount(total);
            }
        }
        List<C> list = queryColumn(cClass, query);
        page.setItems(list);
        return page;
    }
    //</editor-fold>
    //<editor-fold desc="for list">
    public List<Map<String, Object>> queryForList(Class<?> entityClass, IWhereWrap where) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.setWhereWrapInterface(where);
        return queryForList(entityClass, query);
    }

    public List<Map<String, Object>> queryForList(Class<?> entityClass, EntityQuery query) {
        query.setDialect(dialect);
        Map sqlParas = new HashMap<>();
        String sql = query.getNameParamSql(sqlParas);
        return queryForList(sql, sqlParas);
    }
    //</editor-fold>
    //<editor-fold desc="for rowset">

    public SqlRowSet queryForRowSet(Class<?> entityClass, IWhereWrap where) {
        EntityQuery query = new EntityQuery(entityClass, dialect);
        query.setWhereWrapInterface(where);
        return queryForRowSet(entityClass, query);
    }

    public SqlRowSet queryForRowSet(Class<?> entityClass, EntityQuery query) {
        query.setDialect(dialect);
        Map sqlParas = new HashMap<>();
        String sql = query.getNameParamSql(sqlParas);
        return queryForRowSet(sql, sqlParas);
    }

    //</editor-fold>

    //<editor-fold desc="build schema">

    public DatabaseMetaData getDatabaseMetaData(){
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            return connection.getMetaData();
        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }finally {
            if(connection!=null){
                try {
                    connection.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
                connection=null;
            }
        }
    }
    /**
     * 重建所有的表
     *
     * @param entityClass dd
     * @throws  DataAccessException dd
     */
    public void rebuildSchema(Class... entityClass) throws DataAccessException
    {
        rebuildSchema(true,entityClass);
    }
    /**
     * 重建所有的表
     *
     * @param entityClass ff
     * @param createIndex dd
     * @throws DataAccessException dd
     */
    public void rebuildSchema(boolean createIndex,Class... entityClass) throws DataAccessException {
        for (Class clazz : entityClass) {
//            doDropIndexs(clazz);
            try {
                doDropTable(clazz);
            } catch (Exception ex) {
                logger.debug("doDropTable error " + ex.getMessage());
            }

            doCreateTable(clazz);
            if(createIndex) {
                doCreateIndexs(clazz);
            }
        }
    }

    /**
     * 创建表
     */
    public <T> int doCreateTable(Class<T> entityClass) {
        CreateTableSchemaClause clause = new CreateTableSchemaClause(this.dialect, entityClass);
        String sql = clause.getSql();
        return executeNoQuery(sql);
    }

    /**
     * 删除表
     */
    public <T> int doDropTable(Class<T> entityClass) {
        DropTableSchemaClause clause = new DropTableSchemaClause(this.dialect, entityClass);
        String sql = clause.getSql();
        return executeNoQuery(sql);
    }

    /**
     * 删除表内容
     */
    public <T> int doTruncateTable(Class<T> entityClass) {
        ObjectTableMeta<? extends Object> table = ObjectTableMeta.getTable(entityClass);
        String sql = dialect.sqlTruncateTable(table.getTableName());
        return executeNoQuery(sql);
    }

    /**
     * 创建表
     */
    public <T> int doCreateIndexs(Class<T> entityClass) {
        CreateIndexSchemaClause clause = new CreateIndexSchemaClause(this.dialect, entityClass);
        String sql = clause.getSql();
        List<CreateIndexItem> items = clause.getCreateIndexWrap().getItems();
        for (CreateIndexItem item : items) {
            executeNoQuery(item.getSql());
        }
        return 1;
    }

    /**
     * 删除表
     */
    public <T> int doDropIndexs(Class<T> entityClass) {
        DropIndexSchemaClause clause = new DropIndexSchemaClause(this.dialect, entityClass);
        String sql = clause.getSql();
        List<DropIndexItem> items = clause.getDropIndexWrap().getItems();
        for (DropIndexItem item : items) {
            executeNoQuery(item.getSql());
        }
        return 1;
    }

    //</editor-fold>

    public  <T> T query(String sql,ResultSetExtractor<T> rsExtractor,Object... args){
        return query(sql, args, rsExtractor);
    }

    //<editor-fold desc="event">
    void batchInvokeEvent(ObjectTableMeta table, Collection targets, Event event) {
        batchInvokeEvent(table, targets, event);
        if (entityEventCallback != null) {
            entityEventCallback.batchInvokeEvent(targets, event);
        }
    }

    void invokeEvent(ObjectTableMeta table, Object target, Event event) {
        table.invokeEvent(target, event);
        if (entityEventCallback != null) {
            entityEventCallback.invokeEvent(target, event);
        }
    }

    public EntityEventCallback getEntityEventCallback() {
        return entityEventCallback;
    }

    public void setEntityEventCallback(EntityEventCallback entityEventCallback) {
        this.entityEventCallback = entityEventCallback;
    }

    protected <T> T ThrowDataAccessException(boolean checkNull, Class<T> tClass, SmthExceptionDict smthExceptionCode) {
        if (checkNull) {
            throw new SmthDataAccessException(smthExceptionCode);
        }
        return null;
    }
    //</editor-fold>


}
