package org.jsmth.data.jdbc;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.DialectFactory;
import org.jsmth.data.dialect.MySQLDialect;
import org.jsmth.data.jdbc.conf.JdbcConfig;

import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;

/**
 * Created by mason on 15/12/21.
 */
public class SmthDataSource extends BasicDataSource {
    protected Logger logger = Logger.getLogger("SmthDataSource");
    Dialect dialect;


    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return logger;
    }

    public SmthDataSource() {
        this(new MySQLDialect());
    }

    public SmthDataSource(String dialect,String host, int port, String database, String options) {
        this(dialect, "mysql", host, port, database, options);
    }
    public SmthDataSource(String dialect, String driver, String host, int port, String database, String options) {
        this(dialect, "jdbc", driver, host, port, database, options);
    }

    public SmthDataSource(String dialect, String connectstyle, String driver, String host, int port, String database, String options) {
        this(dialect);
//        jdbc:mysql://localhost/test?useUnicode=true&amp;characterEncoding=utf-8&amp;autoReconnect=true&amp;autoReconnectForPools=true
        this.url = String.format("%s:%s://%s:%d/%s?%s", connectstyle, driver, host, port, database, options);
    }

    public SmthDataSource(String dialect) {
        this(DialectFactory.getDialect(dialect));
    }

    public SmthDataSource(Dialect dialect) {
        this.dialect = dialect;
        if (StringUtils.isBlank(getDriverClassName())) {
            setDriverClassName(this.dialect.getDriverClassName());
        }
    }

    public SmthDataSource(BasicDataSource ds) {
        setDataSource(ds);
    }

    public SmthDataSource(JdbcConfig config) {
        this.setDriverClassName(config.getDriverClassName());
        this.setUrl(config.getUrl());
        this.setUsername(config.getUsername());
        this.setPassword(config.getPassword());
        this.dialect = config.getDialectType().getDialect();
        setDriverClassName(this.dialect.getDriverClassName());
        setValidationQuery(config.getValidationQuery());
    }

    public void setDataSource(BasicDataSource ds) {
        this.setDriverClassName(ds.getDriverClassName());
        this.setUrl(ds.getUrl());
        this.setUsername(ds.getUsername());
        this.setPassword(ds.getPassword());
        if (SmthDataSource.class.isAssignableFrom(ds.getClass())) {
            this.dialect = ((SmthDataSource) ds).getDialect();
        }
        if (StringUtils.isBlank(getDriverClassName())) {
            setDriverClassName(this.dialect.getDriverClassName());
        }
    }

    public Dialect getDialect() {
        return dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }
}
