package org.jsmth.data.jdbc;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mason on 2017/12/6.
 */
public class Query {
    public static final String FIX_TAG = "%";

    StringBuilder selectSql = new StringBuilder();
    StringBuilder whereSql = new StringBuilder();
    StringBuilder orderSql = new StringBuilder();
    StringBuilder groupSql = new StringBuilder();


    List selectParams = new ArrayList();
    List whereParams = new ArrayList();
    List orderParams = new ArrayList();
    List groupParams = new ArrayList();

    public static Query create() {
        return new Query();
    }

    void test() {

//        Query query = new Query();
//        query.s("").w
    }

    //<editor-fold desc="where">
    //<editor-fold desc="whereLike">
    public Query whereLike(Logic logic, String columnName, Object value) {
        return whereLike(logic, columnName, value);
    }

    public Query whereLike(String columnName, Object value) {
        return whereLike(columnName, value);
    }

    public Query whereLike(Logic logic, String columnName, Object value, boolean after) {
        return whereLike(logic, columnName, value, after);
    }

    public Query whereLike(String columnName, Object value, boolean after) {
        return whereLike(Logic.AND, columnName, value, after);
    }

    public Query whereLike(Logic logic, String columnName, Object value, boolean before, boolean after) {
        if (!before && !after) {
            throw new IllegalArgumentException("befor and after value is both false.");
        }
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        where.append(" like '");
        if (before) {
            where.append(FIX_TAG);
        }
        where.append("?");
        if (after) {
            where.append(FIX_TAG);
        }
        where.append("' ");
        return appendWhere(where.toString(), value);
    }

    public Query whereLike(String columnName, String value, boolean before, boolean after) {
        return whereLike(columnName, value, before, after);
    }

    //</editor-fold>
    //<editor-fold desc="whereIn">
    public Query whereIn(String columnName, Object... values) {
        return whereIn(Logic.AND, columnName, values);
    }

    public Query whereIn(Logic logic, String columnName, Object... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        where.append(" in (");
        StringBuilder in = new StringBuilder();
        for (Object value : values) {
            if (in.length() > 0) {
                in.append(",");
            }
            in.append("?");
        }
        where.append(in.toString());
        where.append(") ");
        return appendWhere(logic, where.toString(), values);
    }

    //</editor-fold>
    //<editor-fold desc="whereNotIn">
    public Query whereNotIn(String columnName, Object... values) {
        return whereNotIn(Logic.AND, columnName, values);
    }

    public Query whereNotIn(Logic logic, String columnName, Object... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        where.append(" not in (");
        StringBuilder in = new StringBuilder();
        for (Object value : values) {
            if (in.length() > 0) {
                in.append(",");
            }
            in.append("?");
        }
        where.append(in.toString());
        where.append(") ");
        return appendWhere(logic, where.toString(), values);
    }

    //</editor-fold>
    //<editor-fold desc="whereEqual">
    public Query whereEqual(Logic logic, String columnName, Object value) {
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        where.append(" = ?");
        return appendWhere(logic, where.toString(), value);
    }

    public Query whereEqual(String columnName, Object value) {
        return whereEqual(Logic.AND, columnName, value);
    }

    public <ENUM extends Enum> Query whereEqual(String columnName, ENUM value, boolean ordinal) {
        return whereEqual(Logic.AND, columnName, value, ordinal);
    }

    public <ENUM extends Enum> Query whereEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        where.append(" = ?");
        if (ordinal) {
            return appendWhere(logic, where.toString(), value.ordinal());
        } else {
            return appendWhere(logic, where.toString(), value.name());
        }
    }

    //</editor-fold>
    //<editor-fold desc="whereNotEqual">
    public Query whereNotEqual(Logic logic, String columnName, Object value) {
        return whereNotEqual(logic, columnName, value);
    }

    public Query whereNotEqual(String columnName, Object value) {
        return whereNotEqual(Logic.AND, columnName, value);
    }

    public <ENUM extends Enum> Query whereNotEqual(String columnName, ENUM value, boolean ordinal) {
        return whereNotEqual(columnName, value, ordinal);
    }

    public <ENUM extends Enum> Query whereNotEqual(Logic logic, String columnName, ENUM value, boolean ordinal) {
        return whereNotEqual(logic, columnName, value, ordinal);
    }

    //</editor-fold>
    //<editor-fold desc="whereLessThan">
    public Query whereLessThan(Logic logic, String columnName, Object value) {
        return whereLessThan(logic, columnName, value);
    }

    public Query whereLessThan(String columnName, Object value) {
        return whereLessThan(columnName, value);
    }

    public Query whereLessThan(String columnName, Object value, boolean equal) {
        return whereLessThan(Logic.AND, columnName, value, equal);
    }

    public Query whereLessThan(Logic logic, String columnName, Object value, boolean equal) {
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        if (equal) {
            where.append(" <= ?");
        } else {
            where.append(" < ?");
        }
        return appendWhere(logic, where.toString(), value);
    }

    //</editor-fold>
    //<editor-fold desc="whereMoreThan">
    public Query whereMoreThan(Logic logic, String columnName, Object value) {
        return whereMoreThan(logic, columnName, value);
    }

    public Query whereMoreThan(String columnName, Object value) {
        return whereMoreThan(columnName, value);
    }

    public Query whereMoreThan(String columnName, Object value, boolean equal) {
        return whereMoreThan(Logic.AND, columnName, value, equal);
    }

    public Query whereMoreThan(Logic logic, String columnName, Object value, boolean equal) {
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        if (equal) {
            where.append(" >= ?");
        } else {
            where.append(" > ?");
        }
        return appendWhere(logic, where.toString(), value);
    }

    //</editor-fold>
    //<editor-fold desc="whereBetweenThan">
    public Query whereBetweenThan(Logic logic, String columnName, Object beginValue, Object endValue) {
        return whereBetweenThan(logic, columnName, beginValue, true, endValue, true);
    }

    public Query whereBetweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        return whereBetweenThan(Logic.AND, columnName, beginValue, beginEqual, endValue, endEqual);
    }

    public Query whereBetweenThan(Logic logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        if (beginEqual) {
            where.append(" >= ?");
        } else {
            where.append(" > ?");
        }
        where.append(" and ");
        where.append(columnName);
        if (endEqual) {
            where.append(" <= ?");
        } else {
            where.append(" < ?");
        }
        return appendWhere(logic, where.toString(), beginValue, endValue);
    }

    //</editor-fold>
    //</editor-fold>
    //<editor-fold desc="select">
    public Query s(String... columnNames) {
        if (columnNames != null) {
            for (String columnName : columnNames) {
                s(columnName, "");
            }
        }
        return this;
    }

    public Query s(String columnName, String aliasName) {
        return s(columnName, aliasName, GroupMethod.DEFAULT);
    }

    public Query s(String columnName, String aliasName, GroupMethod groupMethod) {
        StringBuilder sql = new StringBuilder();
        switch (groupMethod) {
            case COUNT:
                sql.append("count(");
                break;
            case SUM:
                sql.append("sum(");
                break;
            case MIN:
                sql.append("min(");
                break;
            case MAX:
                sql.append("max(");
                break;
            case AVG:
                sql.append("avg(");
                break;
            case ALL:
                sql.append("count(");
                break;
            case DEFAULT:
                sql.append("");
                break;
            default:
                throw new IllegalArgumentException("group method not support.");
        }
        sql.append(columnName);
        if (groupMethod != GroupMethod.DEFAULT) {
            sql.append(")");
        }
        if (aliasName != null && !"".equals(aliasName)) {
            sql.append(" as ");
            sql.append(aliasName);
        }
        return appendSelect(sql.toString());
    }

    public Query s(String select, List params) {
        appendSelect(select, params);
        return this;
    }

    //</editor-fold>
    //<editor-fold desc="group">
    public Query g(String columnName) {
        return appendGroup(columnName, null);
    }

    //</editor-fold>
    //<editor-fold desc="order">
    public Query o(String columnName) {
        return o(columnName, OrderType.ASC);
    }

    public Query o(String columnName, OrderType type) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        switch (type) {
            case DEFAULT:
                break;
            case ASC:
                sql.append(" ASC ");
                break;
            case DESC:
                sql.append(" DESC ");
                break;
        }
        return appendOrder(sql.toString(), null);
    }

    //</editor-fold>
    //<editor-fold desc="base">
    public Query appendSelect(String select) {
        return appendSelect(select, null);
    }

    public Query appendSelect(String select, List params) {
        if (select.length() > 0) {
            this.selectSql.append(",");
        }
        this.selectSql.append(select);
        if (params != null) {
            this.selectParams.addAll(params);
        }

        return this;
    }

    public Query appendWhere(String where, List params) {
        return appendWhere(where, params, Logic.unknow);
    }

    public Query appendWhere(Logic logic, String where, Object... params) {
        List list = new ArrayList();
        if (params != null) {
            for (Object o : list) {
                list.add(o);
            }
        }
        return appendWhere(logic, where, list);
    }

    public Query appendWhere(String where, Object... params) {
        return appendWhere(Logic.unknow, where, params);
    }

    public Query appendWhere(Logic logic, String where, List params) {
        if (where.length() > 0) {
            switch (logic) {
                case AND:
                    this.whereSql.append(" and ");
                    break;
                case OR:
                    this.whereSql.append(" or ");
                    break;
                case NOT:
                    this.whereSql.append(" not ");
                    break;
                case unknow:
                    break;
            }
        }
        this.whereSql.append(where);
        if (params != null) {
            this.whereParams.addAll(params);
        }
        return this;
    }

    public Query appendOrder(String order, List params) {
        if (order.length() > 0) {
            this.orderSql.append(",");
        }
        this.orderSql.append(order);
        if (params != null) {
            this.orderParams.addAll(params);
        }
        return this;
    }

    public Query appendGroup(String group, List params) {
        if (group.length() > 0) {
            this.groupSql.append(",");
        }
        this.groupSql.append(group);
        if (params != null) {
            this.groupParams.addAll(params);
        }
        return this;
    }

    public Query setSelect(String select, List params) {
        this.selectSql = new StringBuilder(select);
        if (params == null) {
            this.selectParams = new ArrayList();
        } else {
            this.selectParams = params;
        }
        return this;
    }

    public Query setWhere(String where, List params) {
        this.whereSql = new StringBuilder(where);
        if (params == null) {
            this.whereParams = new ArrayList();
        } else {
            this.whereParams = params;
        }
        return this;
    }

    public Query setOrder(String order, List params) {
        this.orderSql = new StringBuilder(order);
        if (params == null) {
            this.orderParams = new ArrayList();
        } else {
            this.orderParams = params;
        }
        return this;
    }

    public Query setGroup(String group, List params) {
        this.groupSql = new StringBuilder(group);
        if (params == null) {
            this.groupParams = new ArrayList();
        } else {
            this.groupParams = params;
        }
        return this;
    }

    //</editor-fold>

    //<editor-fold desc="merge">
    public Query merge(Query query) {
        return merge(query, Logic.AND);
    }

    public Query merge(Query query, Logic logic) {
        this.appendSelect(query.selectSql.toString(), query.selectParams);
        this.appendWhere(logic, query.whereSql.toString(), query.whereParams);
        this.appendOrder(query.orderSql.toString(), query.orderParams);
        this.appendGroup(query.groupSql.toString(), query.groupParams);
        return this;
    }

    public Query mergeWhere(Query query) {
        return mergeWhere(query, Logic.AND);
    }

    public Query mergeWhere(Query query, Logic logic) {
        this.appendWhere(logic, query.whereSql.toString(), query.whereParams);
        return this;
    }

    //</editor-fold>
    public String buildWhere(String tablename, List params) {
        StringBuffer sql = new StringBuffer();
        if (whereSql.length() > 0) {
            sql.append(whereSql.toString());
            params.addAll(whereParams);
        }
        if (orderSql.length() > 0) {
            sql.append(" order by " + orderSql.toString());
        }
        return sql.toString();
    }
    public String buildSql(String tablename, List params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        if (selectSql.length() == 0) {
            sql.append("*");
        } else {
            sql.append(this.selectSql.toString());
            params.addAll(selectParams);
        }
        sql.append(" from " + tablename);
        if (whereSql.length() > 0) {
            sql.append(" where " + whereSql.toString());
            params.addAll(whereParams);
        }
        if (orderSql.length() > 0) {
            sql.append(" order by " + orderSql.toString());
        }
        if (groupSql.length() > 0) {
            sql.append(" group by " + groupSql.toString());
        }
        return sql.toString();
    }

    //<editor-fold desc="get set">
    public StringBuilder getSelectSql() {
        return selectSql;
    }

    public void setSelectSql(StringBuilder selectSql) {
        this.selectSql = selectSql;
    }

    public StringBuilder getWhereSql() {
        return whereSql;
    }

    public void setWhereSql(StringBuilder whereSql) {
        this.whereSql = whereSql;
    }

    public StringBuilder getOrderSql() {
        return orderSql;
    }

    public void setOrderSql(StringBuilder orderSql) {
        this.orderSql = orderSql;
    }

    public StringBuilder getGroupSql() {
        return groupSql;
    }

    public void setGroupSql(StringBuilder groupSql) {
        this.groupSql = groupSql;
    }

    public List getSelectParams() {
        return selectParams;
    }

    public void setSelectParams(List selectParams) {
        this.selectParams = selectParams;
    }

    public List getWhereParams() {
        return whereParams;
    }

    public void setWhereParams(List whereParams) {
        this.whereParams = whereParams;
    }

    public List getOrderParams() {
        return orderParams;
    }

    public void setOrderParams(List orderParams) {
        this.orderParams = orderParams;
    }

    public List getGroupParams() {
        return groupParams;
    }

    public void setGroupParams(List groupParams) {
        this.groupParams = groupParams;
    }
    //</editor-fold>

}
