package org.jsmth.data.jdbc;

import org.apache.commons.lang.Validate;
import org.jsmth.jorm.jdbc.Column;
import org.jsmth.jorm.jdbc.Table;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import java.util.Map;

/**
 * 增强的SqlParameterSource，解决了枚举和Embedded的问题
 *
 * @author mason
 */
@SuppressWarnings({"unchecked"})
public class MapSqlParameterSourceEx implements SqlParameterSource {

    Map paras;

    public MapSqlParameterSourceEx(Map paras) {
        this.paras = paras;
    }

    @Override
    public boolean hasValue(String s) {
        return true;
    }

    @Override
    public Object getValue(String s) throws IllegalArgumentException {
        return paras.get(s);
    }

    @Override
    public int getSqlType(String s) {
        Object value = paras.get(s);
        if(value==null){
            return 0;
        }
        return StatementCreatorUtils.javaTypeToSqlParameterType(value.getClass());
    }

    @Override
    public String getTypeName(String s) {
        return null;
    }

}
