package org.jsmth.data.jdbc;



import org.jsmth.data.sql.EntityDelete;
import org.jsmth.data.sql.EntityQuery;
import org.jsmth.data.sql.EntityUpdate;
import org.jsmth.data.sql.wrap.*;
import org.jsmth.jorm.jdbc.EntityEventCallback;
import org.jsmth.page.Page;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.rowset.SqlRowSet;

import javax.persistence.MappedSuperclass;
import java.util.*;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
public interface ITableJdbcDao extends IBaseJdbcDao {

    //<editor-fold desc="update">
    <T> int update(Class<T> entityClass, UpdateFieldWrap updateFieldWrap, IWhereWrap whereWrap) ;
    <T> int update(Class<T> entityClass, EntityUpdate entityUpdate);


    <T> int updateModel(T model, UpdateFieldWrap updateFieldWrap, IWhereWrap whereWrap);

    <T> int updateField(T model, UpdateFieldWrap updateFieldWrap, IWhereWrap whereWrap);

    //</editor-fold>
    //<editor-fold desc="delete">
    <T> int delete(Class<T> entityClass, IWhereWrap whereWrap);

    <T> int delete(EntityDelete entityDelete);

    //</editor-fold>
    //<editor-fold desc="insert">
    <T> Number insertBackKey(Class<T> entityClass, InsertFieldWrap insertFieldWrap, InsertValueWrap insertValueWrap);

    <T> int insert(Class<T> entityClass, InsertFieldWrap insertFieldWrap, InsertValueWrap insertValueWrap);

    <T> int insert(Class<T> entityClass, Map<String, Object> fieldValue);
    //</editor-fold>
    //<editor-fold desc="queryAll">
    <T> List<T> queryAll(Class<T> entityClass);

    <T> Page<T> queryAllForPage(Class<T> entityClass, int pageNumber, int pageSize) ;

    //</editor-fold>
    //<editor-fold desc="query">
    <T> List<T> query(Class<T> entityClass, IWhereWrap where);

    <T> List<T> query(Class<T> tClass, EntityQuery query);
    <T> List<T> query(Class<T> tClass, String select,String where,Object...params);

    //</editor-fold>
    //<editor-fold desc="for page">
    <T> Page<T> queryPage(Class<T> entityClass, IWhereWrap where, int pageNumber, int pageSize);

    <T> Page<T> queryPage(Class<T> entityClass, IWhereWrap where, int pageNumber, int pageSize, boolean totalRecord) ;
    <T> Page<T> queryPage(Class<T> entityClass,  int pageNumber, int pageSize, boolean totalRecord,String select,String where,Object...params) ;
    <T> Page<T> queryPage(Class<T> entityClass, EntityQuery query);
    //</editor-fold>
    //<editor-fold desc="For number">
    Number queryForNumber(String sql, Map<String, ?> paramMap);

    Number queryForNumber(String sql, SqlParameterSource paramSource) ;

    int queryForInt(String sql, Map<String, ?> paramMap) ;

    int queryForInt(String sql, SqlParameterSource paramSource) ;

    long queryForLong(String sql, Map<String, ?> paramMap);

    long queryForLong(String sql, SqlParameterSource paramSource) ;
    //</editor-fold>
    //<editor-fold desc="for object">
    <T> T queryForObject(Class<T> entityClass, IWhereWrap where);

    <T> T queryForObject(Class<T> entityClass, EntityQuery query);

    <T> T queryForObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) ;
    //</editor-fold>
    //<editor-fold desc="for object">
    <T> int queryForInt(Class<T> entityClass, IWhereWrap where);

    <T> int queryForInt(Class<T> entityClass, EntityQuery query);
    //</editor-fold>
    //<editor-fold desc="for map">
    Map<String, Object> queryForMap(Class<?> entityClass, IWhereWrap where);
    Map<String, Object> queryForMap(Class<?> entityClass, String where, Object... params);

    Map<String, Object> queryForMap(Class<?> entityClass, EntityQuery query) ;
    //</editor-fold>
    //<editor-fold desc="for queryColumn">
    <C> List<C> queryColumn(Class<?> entityClass, Class<C> cClass, String fieldName, IWhereWrap where);
    public <C> List<C> queryColumn(Class<?> entityClass, Class<C> cClass, String fieldName, String where, Object... params);
    <T> List<T> queryColumn(Class<T> tClass, EntityQuery query) ;
    //</editor-fold>
    //<editor-fold desc="for queryPageColumn">
    <T, C> Page<C> queryPageColumn(Class<T> entityClass, Class<C> cClass, String columnName, IWhereWrap where, int pageNumber, int pageSize) ;
    <T, C> Page<C> queryPageColumn(Class<T> entityClass, Class<C> cClass, String columnName, IWhereWrap where, int pageNumber, int pageSize, boolean totalRecord) ;
    <T, C> Page<C> queryPageColumn(Class<T> entityClass, Class<C> cClass, String columnName,int pageNumber, int pageSize, boolean totalRecord,String where,Object...params) ;
    <C> Page<C> queryPageColumn(Class<C> cClass, EntityQuery query);
    //</editor-fold>
    //<editor-fold desc="for list">
    List<Map<String, Object>> queryForList(Class<?> entityClass, IWhereWrap where) ;

    List<Map<String, Object>> queryForList(Class<?> entityClass, EntityQuery query);
    //</editor-fold>
    //<editor-fold desc="for rowset">

    SqlRowSet queryForRowSet(Class<?> entityClass, IWhereWrap where) ;

    SqlRowSet queryForRowSet(Class<?> entityClass, EntityQuery query);
    //</editor-fold>

    //<editor-fold desc="build schema">

    /**
     * 重建所有的表
     *
     * @param entityClass dfd
     */
    void rebuildSchema(Class... entityClass) ;


    <T> int doCreateTable(Class<T> entityClass);

    <T> int doDropTable(Class<T> entityClass);

    <T> int doTruncateTable(Class<T> entityClass) ;


    <T> int doCreateIndexs(Class<T> entityClass) ;


    <T> int doDropIndexs(Class<T> entityClass);

    //</editor-fold>

    void setEntityEventCallback(EntityEventCallback entityEventCallback);

}
