package org.jsmth.data.jdbc;

import org.jsmth.domain.Identifier;
import org.jsmth.data.sql.wrap.WhereWrap;
import org.jsmth.page.Page;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
 public interface IJdbcDao extends ITableJdbcDao {

    //<editor-fold desc="save">
    /**
     * 保存实体。如果实体不存在则添加
     *
     * @param entity ff
     * @param <T> ff
     * @return 返回信息
     */
     <T extends Identifier> T save(T entity);
    //</editor-fold>
    //<editor-fold desc="insert">
     <T extends Identifier> T insert(T model);
    //</editor-fold>
    //<editor-fold desc="update">
      <T> int updateModelById(T entity, String... ommitFieldNames);
      <T> int updateModelById(T entity, boolean exclude, String... fieldNames) ;

      <T> int updateModel(T model, WhereWrap whereWrap, boolean exclude, String... fieldNames) ;

    //</editor-fold>
    //<editor-fold desc="delete">
     int deleteById(Class eClass, Serializable id);
    <K extends Serializable, T extends Identifier<K>>  int deleteByIds(Class<T> eClass, Collection<K> ids);
     <K extends Serializable> int deleteAll(Collection entitys);
     <T extends Identifier> int delete(T entity);
    //</editor-fold>
    //<editor-fold desc="query">

     <K extends Serializable, T extends Identifier<K>> T getOrCreateById(Class<T> entityClass, K id);

     <T> List<T> query(String sql, Class<T> tClass) ;
     <K extends Serializable, T extends Identifier> T getById(Class<T> mClass, K id);

    //</editor-fold>

    //<editor-fold desc="for queryByColumns">
     <T> List<T> queryByColumns(Class<T> entityClass, String fieldName, Object... columnValues) ;
     <T> Page<T> queryPageByColumns(Class<T> entityClass,int pageNumber,int pageSize, String fieldName, Object... columnValues) ;

    //</editor-fold>
}
