package org.jsmth.data.jdbc;

import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 16/1/4.
 */
@MappedSuperclass
public interface IBaseJdbcDao extends Serializable{

    //<editor-fold desc="executeNoQuery">


    int executeNoQuery(String sql) ;

    int executeNoQuery(String sql, Map<String, ?> paramMap);

    //</editor-fold>
    //<editor-fold desc="executeNoQuery">
    int[] batchExecuteNoQuery(String sql, Map<String, ?>[] paramMaps);

    int[] batchExecuteNoQuery(String sql, SqlParameterSource[] paramMaps);
    //</editor-fold>

    //<editor-fold desc="execute">
    List<Map<String,Object>> queryForListMap(String sql);
    public <T> T queryForObject(Class<T> requestType, String sql, Object... sqlParams);
    public <T> List<T> queryForList(Class<T> requestType, String sql, Object... sqlParams);
    public Map<String, Object> queryForMap(String sql, Object... sqlParams);
    public List<Map<String, Object>> queryForListMap(String sql, Object... sqlParams);

    public <T> List<T> queryForEntityList(Class<T> entityType, String sql, Object... sqlParams);
    public <T> int execUpdate(String sql, Object... sqlParams);

    String buildQuerySql(Class entityClass, String select,String where);
    String buildDeleteSql(Class entityClass, String where);
    //</editor-fold>

    List<Map<String,Object>> findMaps(Class entityClass, String where, Object... params);
    List<Map<String,Object>> findMaps(Class entityClass, String select, String where, Object... params);
    Map<String,Object> getMap(Class entityClass, String where, Object... params);
    Map<String,Object> getMap(Class entityClass, String select, String where, Object... params);
}
