package org.jsmth.data.jdbc;

import org.apache.commons.dbcp.BasicDataSource;
import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.DialectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;

/**
 * Created by mason on 15/12/28.
 */
public class DataSourceFacotry {
    protected static Logger logger = LoggerFactory.getLogger(DataSourceFacotry.class);

    public static DataSource createDataSource(String dialect, String host, int port, String database, String username, String password) {
        return createDataSource(DialectFactory.getDialect(dialect), host, port, database, username, password);
    }
    public static DataSource createDataSource(Dialect dialect, String host, int port, String database, String username, String password) {
        String url = dialect.buildConnectUrl(host, port, database);
        return createDataSource(dialect,url,username,password);
    }
    public static DataSource createDataSource(String dialect, String url, String username, String password) {
        return createDataSource(DialectFactory.getDialect(dialect),url,username,password);
    }
    public static DataSource createDataSource(Dialect dialect, String url, String username, String password) {
        String driver = dialect.getDriverClassName();
        SmthDataSource ds = new SmthDataSource();
        ds.setUrl(url);
        ds.setUsername(username);
        ds.setPassword(password);
        ds.setDriverClassName(driver);
        ds.setDialect(dialect);

        logger.debug("DataSource:"+driver+"@####@"+url+"@####@"+username+"@####@"+password);
        return ds;
    }

}
