package org.jsmth.data.jdbc;

import org.apache.commons.lang.Validate;
import org.jsmth.data.schema.ObjectTableMeta;
import org.jsmth.jorm.jdbc.Column;
import org.jsmth.jorm.jdbc.ColumnType;
import org.jsmth.jorm.jdbc.Table;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

/**
 * 增强的SqlParameterSource，解决了枚举和Embedded的问题
 *
 * @author mason
 */
@SuppressWarnings({"unchecked"})
public class BeanPropertySqlParameterSourceEx implements SqlParameterSource {

    private ObjectTableMeta table;

    private BeanWrapper beanWrapper;
    Object instance;

    public BeanPropertySqlParameterSourceEx(Object object) {
        table = ObjectTableMeta.getTable(object.getClass());
        this.beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess(object);
        instance=object;
    }


    public boolean hasValue(String paramName) {
        return true;
    }

    public Object getValue(String paramName) throws IllegalArgumentException {
        return table.getFieldValue(paramName,instance);
    }

    /**
     * Derives a default SQL type from the corresponding property type.
     *
     * @see StatementCreatorUtils#javaTypeToSqlParameterType
     */
    public int getSqlType(String paramName) {
        Column column = table.getColumnByFieldName(paramName);
//        Class propType =column.getClass() this.beanWrapper.getPropertyType(column.getFieldName());
        Class propType=column.getType().getMappingClazz();
        return StatementCreatorUtils.javaTypeToSqlParameterType(propType);
    }

    @Override
    public String getTypeName(String paramName) {
        return null;
    }

}
