package org.jsmth.data.domain.support;


import org.apache.commons.lang.StringUtils;
import org.jsmth.data.domain.ExtModel;

import javax.persistence.GenerationType;
import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 15/12/13.
 */
@MappedSuperclass
public class ExtStringModel extends ExtModel<String> {

    @javax.persistence.Id
    @javax.persistence.GeneratedValue(strategy = GenerationType.TABLE)
    String id="";

    public ExtStringModel() {
        setId("");
    }

    public ExtStringModel(String id) {
        super(id);
    }

    public ExtStringModel(ExtModel<String> model) {
        super(model);
    }

    @Override
    public Class<String> getKeyClass() {
        return String.class;
    }

    @Override
    public boolean isNew() {
        return StringUtils.isBlank(getId());
    }

    @Override
    public String getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(String id) {
        this.id=id;
    }

    @Override
    public void clear() {
        setId("");
    }
}
