package org.jsmth.data.domain.support;


import org.jsmth.data.domain.ExtModel;
import org.jsmth.util.IdentifierKeyHelper;

import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 15/12/13.
 */
@MappedSuperclass
public class ExtGuidModel extends ExtStringModel {
    public ExtGuidModel() {
        setId(buildKey());
    }

    public ExtGuidModel(String id) {
        super(id);
    }

    public ExtGuidModel(ExtModel<String> model) {
        super(model);
    }

    public String buildKey() {
        return IdentifierKeyHelper.getGuidIdKey();
    }

    @Override
    public void preInsert() {
        setId(buildKey());
        super.preInsert();
    }
}
